/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.management.resources;

import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.slider.core.conf.ConfTree;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ConfTreeResource {
    private final String href;
    private final Map<String, Object> metadata;
    private final Map<String, String> global;
    private final Map<String, Map<String, String>> components;

    public ConfTreeResource() {
        this(null, null);
    }

    public ConfTreeResource(ConfTree confTree, UriBuilder uriBuilder) {
        if (uriBuilder != null && confTree != null) {
            this.metadata = confTree.metadata;
            this.global = confTree.global;
            this.components = confTree.components;
            this.href = uriBuilder.build(new Object[0]).toASCIIString();
        } else {
            this.href = null;
            this.metadata = null;
            this.global = null;
            this.components = null;
        }
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getGlobal() {
        return this.global;
    }

    public Map<String, Map<String, String>> getComponents() {
        return this.components;
    }

    public String getHref() {
        return this.href;
    }
}

