/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AgentLaunchParameter {
    public static final Logger log = LoggerFactory.getLogger(AgentLaunchParameter.class);
    private static final String DEFAULT_PARAMETER = "";
    private static final String ANY_COMPONENT = "ANY";
    private static final String NONE_VALUE = "NONE";
    private final Map<String, CommandTracker> launchParameterTracker;

    public AgentLaunchParameter(String parameters) {
        this.launchParameterTracker = this.parseExpectedLaunchParameters(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextLaunchParameter(String componentName) {
        if (this.launchParameterTracker != null && (this.launchParameterTracker.containsKey(componentName) || this.launchParameterTracker.containsKey(ANY_COMPONENT))) {
            AgentLaunchParameter agentLaunchParameter = this;
            synchronized (agentLaunchParameter) {
                CommandTracker indexTracker = null;
                indexTracker = this.launchParameterTracker.containsKey(componentName) ? this.launchParameterTracker.get(componentName) : this.launchParameterTracker.get(ANY_COMPONENT);
                return indexTracker.getNextCommand();
            }
        }
        return DEFAULT_PARAMETER;
    }

    Map<String, CommandTracker> parseExpectedLaunchParameters(String launchParameters) {
        HashMap<String, CommandTracker> trackers = null;
        if (launchParameters != null && launchParameters.length() > 0) {
            String[] componentSpecificParameters;
            String[] stringArray = componentSpecificParameters = launchParameters.split(Pattern.quote("|"));
            int n = componentSpecificParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String[] parameters;
                String componentSpecificParameter = stringArray[n2];
                if (componentSpecificParameter.length() != 0 && (parameters = componentSpecificParameter.split(Pattern.quote(":"))).length > 1 && parameters[0].length() > 0) {
                    int index = 1;
                    while (index < parameters.length) {
                        if (parameters[index].equals(NONE_VALUE)) {
                            parameters[index] = DEFAULT_PARAMETER;
                        }
                        ++index;
                    }
                    if (trackers == null) {
                        trackers = new HashMap<String, CommandTracker>(10);
                    }
                    String componentName = parameters[0];
                    CommandTracker tracker = new CommandTracker(Arrays.copyOfRange(parameters, 1, parameters.length));
                    trackers.put(componentName, tracker);
                }
                ++n2;
            }
        }
        return trackers;
    }

    class CommandTracker {
        private final int maxIndex;
        private final String[] launchCommands;
        private int currentIndex = 0;

        CommandTracker(String[] launchCommands) {
            this.maxIndex = launchCommands.length - 1;
            this.launchCommands = launchCommands;
        }

        String getNextCommand() {
            String retVal = this.launchCommands[this.currentIndex];
            if (this.currentIndex != this.maxIndex) {
                ++this.currentIndex;
            }
            return retVal;
        }
    }
}

