/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.zk;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniZooKeeperCluster
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(MiniZooKeeperCluster.class);
    private static final int TICK_TIME = 2000;
    private static final int CONNECTION_TIMEOUT = 30000;
    public static final int MAX_CLIENT_CONNECTIONS = 1000;
    private boolean started;
    private int defaultClientPort = 0;
    private int clientPort;
    private final List<NIOServerCnxnFactory> standaloneServerFactoryList;
    private final List<ZooKeeperServer> zooKeeperServers;
    private final List<Integer> clientPortList;
    private int activeZKServerIndex;
    private int tickTime = 0;
    private File baseDir;
    private final int numZooKeeperServers;
    private String zkQuorum = "";

    public MiniZooKeeperCluster(int numZooKeeperServers) {
        super("MiniZooKeeperCluster");
        this.numZooKeeperServers = numZooKeeperServers;
        this.started = false;
        this.activeZKServerIndex = -1;
        this.zooKeeperServers = new ArrayList<ZooKeeperServer>();
        this.clientPortList = new ArrayList<Integer>();
        this.standaloneServerFactoryList = new ArrayList<NIOServerCnxnFactory>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    public void setDefaultClientPort(int clientPort) {
        if (clientPort <= 0) {
            throw new IllegalArgumentException("Invalid default ZK client port: " + clientPort);
        }
        this.defaultClientPort = clientPort;
    }

    private int selectClientPort(Random r) {
        if (this.defaultClientPort > 0) {
            return this.defaultClientPort;
        }
        return 49152 + r.nextInt(16128);
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public int getBackupZooKeeperServerNum() {
        return this.zooKeeperServers.size() - 1;
    }

    public int getZooKeeperServerNum() {
        return this.zooKeeperServers.size();
    }

    private static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    protected void serviceStart() throws Exception {
        this.startup();
    }

    private int startup() throws IOException, InterruptedException {
        if (this.numZooKeeperServers <= 0) {
            return -1;
        }
        MiniZooKeeperCluster.setupTestEnv();
        this.started = true;
        this.baseDir = File.createTempFile("zookeeper", ".dir");
        this.recreateDir(this.baseDir);
        StringBuilder quorumList = new StringBuilder();
        Random rnd = new Random();
        int tentativePort = this.selectClientPort(rnd);
        int i = 0;
        while (i < this.numZooKeeperServers) {
            NIOServerCnxnFactory standaloneServerFactory;
            File dir = new File(this.baseDir, "zookeeper_" + i).getAbsoluteFile();
            this.recreateDir(dir);
            int tickTimeToUse = this.tickTime > 0 ? this.tickTime : 2000;
            ZooKeeperServer server = new ZooKeeperServer(dir, dir, tickTimeToUse);
            while (true) {
                try {
                    standaloneServerFactory = new NIOServerCnxnFactory();
                    standaloneServerFactory.configure(new InetSocketAddress(tentativePort), 1000);
                }
                catch (BindException e) {
                    LOG.debug("Failed binding ZK Server to client port: " + tentativePort, (Throwable)e);
                    if (this.defaultClientPort > 0) {
                        return -1;
                    }
                    tentativePort = this.selectClientPort(rnd);
                    continue;
                }
                break;
            }
            standaloneServerFactory.startup(server);
            if (!MiniZooKeeperCluster.waitForServerUp(tentativePort, 30000L)) {
                throw new IOException("Waiting for startup of standalone server");
            }
            this.clientPortList.add(tentativePort);
            this.standaloneServerFactoryList.add(standaloneServerFactory);
            this.zooKeeperServers.add(server);
            if (quorumList.length() > 0) {
                quorumList.append(",");
            }
            quorumList.append("localhost:").append(tentativePort);
            ++tentativePort;
            ++i;
        }
        this.activeZKServerIndex = 0;
        this.clientPort = this.clientPortList.get(this.activeZKServerIndex);
        this.zkQuorum = quorumList.toString();
        LOG.info("Started MiniZK Cluster and connect 1 ZK server on client port: " + this.clientPort);
        return this.clientPort;
    }

    private void recreateDir(File dir) throws IOException {
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Could not delete zk base directory: " + dir);
        }
        try {
            dir.mkdirs();
        }
        catch (SecurityException e) {
            throw new IOException("creating dir: " + dir, e);
        }
    }

    private void deleteBaseDir() {
        if (this.baseDir != null) {
            this.baseDir.delete();
            this.baseDir = null;
        }
    }

    protected void serviceStop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            int i = 0;
            while (i < this.standaloneServerFactoryList.size()) {
                NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(i);
                int clientPort = this.clientPortList.get(i);
                standaloneServerFactory.shutdown();
                if (!MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) {
                    throw new IOException("Waiting for shutdown of standalone server");
                }
                ++i;
            }
            for (ZooKeeperServer zkServer : this.zooKeeperServers) {
                zkServer.getZKDatabase().close();
            }
        }
        finally {
            this.activeZKServerIndex = 0;
            this.standaloneServerFactoryList.clear();
            this.clientPortList.clear();
            this.zooKeeperServers.clear();
        }
        LOG.info("Shutdown MiniZK cluster with all ZK servers");
    }

    public int killCurrentActiveZooKeeperServer() throws IOException, InterruptedException {
        if (!this.started || this.activeZKServerIndex < 0) {
            return -1;
        }
        NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(this.activeZKServerIndex);
        int clientPort = this.clientPortList.get(this.activeZKServerIndex);
        standaloneServerFactory.shutdown();
        if (!MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.zooKeeperServers.get(this.activeZKServerIndex).getZKDatabase().close();
        this.standaloneServerFactoryList.remove(this.activeZKServerIndex);
        this.clientPortList.remove(this.activeZKServerIndex);
        this.zooKeeperServers.remove(this.activeZKServerIndex);
        LOG.info("Kill the current active ZK servers in the cluster on client port: " + clientPort);
        if (this.standaloneServerFactoryList.size() == 0) {
            return -1;
        }
        clientPort = this.clientPortList.get(this.activeZKServerIndex);
        LOG.info("Activate a backup zk server in the cluster on client port: " + clientPort);
        return clientPort;
    }

    public void killOneBackupZooKeeperServer() throws IOException, InterruptedException {
        if (!this.started || this.activeZKServerIndex < 0 || this.standaloneServerFactoryList.size() <= 1) {
            return;
        }
        int backupZKServerIndex = this.activeZKServerIndex + 1;
        NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(backupZKServerIndex);
        int clientPort = this.clientPortList.get(backupZKServerIndex);
        standaloneServerFactory.shutdown();
        if (!MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.zooKeeperServers.get(backupZKServerIndex).getZKDatabase().close();
        this.standaloneServerFactoryList.remove(backupZKServerIndex);
        this.clientPortList.remove(backupZKServerIndex);
        this.zooKeeperServers.remove(backupZKServerIndex);
        LOG.info("Kill one backup ZK servers in the cluster on client port: " + clientPort);
    }

    private static boolean waitForServerDown(int port, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = null;
                try {
                    sock = new Socket("localhost", port);
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeSocket(sock);
                    throw throwable;
                }
                IOUtils.closeSocket((Socket)sock);
            }
            catch (IOException iOException) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            Thread.sleep(250L);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForServerUp(int port, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                BufferedReader reader;
                Socket sock;
                block6: {
                    sock = null;
                    sock = new Socket("localhost", port);
                    reader = null;
                    try {
                        OutputStream outstream = sock.getOutputStream();
                        outstream.write("stat".getBytes());
                        outstream.flush();
                        InputStreamReader isr = new InputStreamReader(sock.getInputStream());
                        reader = new BufferedReader(isr);
                        String line = reader.readLine();
                        if (line == null || !line.startsWith("Zookeeper version:")) break block6;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeSocket((Socket)sock);
                        IOUtils.closeStream(reader);
                        throw throwable;
                    }
                    IOUtils.closeSocket((Socket)sock);
                    IOUtils.closeStream((Closeable)reader);
                    return true;
                }
                IOUtils.closeSocket((Socket)sock);
                IOUtils.closeStream((Closeable)reader);
            }
            catch (IOException e) {
                LOG.debug("server localhost:" + port + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            Thread.sleep(250L);
        }
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getZkQuorum() {
        return this.zkQuorum;
    }
}

