/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.UsageException;

@Parameters(commandNames={"resolve"}, commandDescription="Query the registry of a YARN application")
public class ActionResolveArgs
extends AbstractActionArgs {
    public static final String USAGE = "Usage: resolve --path <path> [--list] [--out <filename> ] [--destdir <directory> ] ";
    @Parameter(names={"--list"}, description="list services")
    public boolean list;
    @Parameter(names={"--path"}, description="resolve a path")
    public String path;
    @Parameter(names={"--destdir"}, description="destination directory for operations")
    public File destdir;
    @Parameter(names={"--out", "-o"}, description="dest file")
    public File out;

    @Override
    public String getActionName() {
        return "resolve";
    }

    @Override
    public int getMinParams() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("resolve").append(" ");
        sb.append("--path").append(" ").append(this.path).append(" ");
        if (this.list) {
            sb.append("--list").append(" ");
        }
        if (this.destdir != null) {
            sb.append("--destdir").append(" ").append(this.destdir).append(" ");
        }
        if (this.out != null) {
            sb.append("--out").append(" ").append(this.out).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void validate() throws BadCommandArgumentsException, UsageException {
        super.validate();
        if (StringUtils.isEmpty((String)this.path)) {
            throw new BadCommandArgumentsException("Missing mandatory argument --path", new Object[0]);
        }
        if (this.list && this.out != null) {
            throw new BadCommandArgumentsException("Argument --out not supported for --list", new Object[0]);
        }
        if (this.out != null && this.destdir != null) {
            throw new BadCommandArgumentsException("--out and --destdir cannot be used together", new Object[0]);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public File getDestdir() {
        return this.destdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public File getOut() {
        return this.out;
    }

    public void setOut(File out) {
        this.out = out;
    }
}

