/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.NullStruct;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.topology.ResourceDeclarer;
import org.apache.storm.topology.base.BaseWindowedBolt;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.fluent.ChainedAggregatorDeclarer;
import org.apache.storm.trident.fluent.GlobalAggregationScheme;
import org.apache.storm.trident.fluent.GroupedStream;
import org.apache.storm.trident.fluent.IAggregatableStream;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.Assembly;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Consumer;
import org.apache.storm.trident.operation.Filter;
import org.apache.storm.trident.operation.FlatMapFunction;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.MapFunction;
import org.apache.storm.trident.operation.ReducerAggregator;
import org.apache.storm.trident.operation.builtin.Max;
import org.apache.storm.trident.operation.builtin.MaxWithComparator;
import org.apache.storm.trident.operation.builtin.Min;
import org.apache.storm.trident.operation.builtin.MinWithComparator;
import org.apache.storm.trident.operation.impl.CombinerAggStateUpdater;
import org.apache.storm.trident.operation.impl.ConsumerExecutor;
import org.apache.storm.trident.operation.impl.FilterExecutor;
import org.apache.storm.trident.operation.impl.FlatMapFunctionExecutor;
import org.apache.storm.trident.operation.impl.GlobalBatchToPartition;
import org.apache.storm.trident.operation.impl.IndexHashBatchToPartition;
import org.apache.storm.trident.operation.impl.MapFunctionExecutor;
import org.apache.storm.trident.operation.impl.ReducerAggStateUpdater;
import org.apache.storm.trident.operation.impl.SingleEmitAggregator;
import org.apache.storm.trident.operation.impl.TrueFilter;
import org.apache.storm.trident.partition.GlobalGrouping;
import org.apache.storm.trident.partition.IdentityGrouping;
import org.apache.storm.trident.partition.IndexHashGrouping;
import org.apache.storm.trident.planner.Node;
import org.apache.storm.trident.planner.NodeStateInfo;
import org.apache.storm.trident.planner.PartitionNode;
import org.apache.storm.trident.planner.ProcessorNode;
import org.apache.storm.trident.planner.processor.AggregateProcessor;
import org.apache.storm.trident.planner.processor.EachProcessor;
import org.apache.storm.trident.planner.processor.MapProcessor;
import org.apache.storm.trident.planner.processor.PartitionPersistProcessor;
import org.apache.storm.trident.planner.processor.ProjectedProcessor;
import org.apache.storm.trident.planner.processor.StateQueryProcessor;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateSpec;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.util.TridentUtils;
import org.apache.storm.trident.windowing.InMemoryWindowsStoreFactory;
import org.apache.storm.trident.windowing.WindowTridentProcessor;
import org.apache.storm.trident.windowing.WindowsStateFactory;
import org.apache.storm.trident.windowing.WindowsStateUpdater;
import org.apache.storm.trident.windowing.WindowsStoreFactory;
import org.apache.storm.trident.windowing.config.SlidingCountWindow;
import org.apache.storm.trident.windowing.config.SlidingDurationWindow;
import org.apache.storm.trident.windowing.config.TumblingCountWindow;
import org.apache.storm.trident.windowing.config.TumblingDurationWindow;
import org.apache.storm.trident.windowing.config.WindowConfig;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class Stream
implements IAggregatableStream,
ResourceDeclarer<Stream> {
    final Node node;
    final String name;
    private final TridentTopology topology;

    protected Stream(TridentTopology topology, String name, Node node) {
        this.topology = topology;
        this.node = node;
        this.name = name;
    }

    public Stream name(String name) {
        return new Stream(this.topology, name, this.node);
    }

    public Stream parallelismHint(int hint) {
        this.node.parallelismHint = hint;
        return this;
    }

    @Override
    public Stream setCPULoad(Number load) {
        this.node.setCPULoad(load);
        return this;
    }

    @Override
    public Stream setMemoryLoad(Number onHeap) {
        this.node.setMemoryLoad(onHeap);
        return this;
    }

    @Override
    public Stream setMemoryLoad(Number onHeap, Number offHeap) {
        this.node.setMemoryLoad(onHeap, offHeap);
        return this;
    }

    @Override
    public Stream addSharedMemory(SharedMemory request) {
        this.node.addSharedMemory(request);
        return this;
    }

    public Stream project(Fields keepFields) {
        this.projectionValidation(keepFields);
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, keepFields, new Fields(new String[0]), new ProjectedProcessor(keepFields)));
    }

    public GroupedStream groupBy(Fields fields) {
        this.projectionValidation(fields);
        return new GroupedStream(this, fields);
    }

    public Stream partitionBy(Fields fields) {
        this.projectionValidation(fields);
        return this.partition(Grouping.fields(fields.toList()));
    }

    public Stream partition(CustomStreamGrouping partitioner) {
        return this.partition(Grouping.custom_serialized(Utils.javaSerialize(partitioner)));
    }

    public Stream partition(Grouping grouping) {
        if (this.node instanceof PartitionNode) {
            return this.each(new Fields(new String[0]), new TrueFilter()).partition(grouping);
        }
        return this.topology.addSourcedNode(this, (Node)new PartitionNode(this.node.streamId, this.name, this.getOutputFields(), grouping));
    }

    public Stream shuffle() {
        return this.partition(Grouping.shuffle(new NullStruct()));
    }

    public Stream localOrShuffle() {
        return this.partition(Grouping.local_or_shuffle(new NullStruct()));
    }

    public Stream global() {
        return this.partition(new GlobalGrouping());
    }

    public Stream batchGlobal() {
        return this.partition(new IndexHashGrouping(0));
    }

    public Stream broadcast() {
        return this.partition(Grouping.all(new NullStruct()));
    }

    public Stream identityPartition() {
        return this.partition(new IdentityGrouping());
    }

    public Stream applyAssembly(Assembly assembly) {
        return assembly.apply(this);
    }

    @Override
    public Stream each(Fields inputFields, Function function, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, TridentUtils.fieldsConcat(this.getOutputFields(), functionFields), functionFields, new EachProcessor(inputFields, function)));
    }

    public Stream each(Function function, Fields functionFields) {
        return this.each(null, function, functionFields);
    }

    public Stream each(Fields inputFields, Filter filter) {
        return this.each(inputFields, new FilterExecutor(filter), new Fields(new String[0]));
    }

    @Override
    public Stream partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, functionFields, functionFields, new AggregateProcessor(inputFields, agg)));
    }

    public Stream partitionAggregate(Aggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(CombinerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().partitionAggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream partitionAggregate(ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().partitionAggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream stateQuery(TridentState state, Fields inputFields, QueryFunction function, Fields functionFields) {
        this.projectionValidation(inputFields);
        String stateId = state.node.stateInfo.id;
        ProcessorNode n = new ProcessorNode(this.topology.getUniqueStreamId(), this.name, TridentUtils.fieldsConcat(this.getOutputFields(), functionFields), functionFields, new StateQueryProcessor(stateId, inputFields, function));
        this.topology.colocate.get(stateId).add(n);
        return this.topology.addSourcedNode(this, (Node)n);
    }

    public Stream stateQuery(TridentState state, QueryFunction function, Fields functionFields) {
        return this.stateQuery(state, null, function, functionFields);
    }

    public TridentState partitionPersist(StateFactory stateFactory, Fields inputFields, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(new StateSpec(stateFactory), inputFields, updater, functionFields);
    }

    public TridentState partitionPersist(StateSpec stateSpec, Fields inputFields, StateUpdater updater, Fields functionFields) {
        this.projectionValidation(inputFields);
        String id = this.topology.getUniqueStateId();
        ProcessorNode n = new ProcessorNode(this.topology.getUniqueStreamId(), this.name, functionFields, functionFields, new PartitionPersistProcessor(id, inputFields, updater));
        n.committer = true;
        n.stateInfo = new NodeStateInfo(id, stateSpec);
        return this.topology.addSourcedStateNode(this, (Node)n);
    }

    public TridentState partitionPersist(StateFactory stateFactory, Fields inputFields, StateUpdater updater) {
        return this.partitionPersist(stateFactory, inputFields, updater, new Fields(new String[0]));
    }

    public TridentState partitionPersist(StateSpec stateSpec, Fields inputFields, StateUpdater updater) {
        return this.partitionPersist(stateSpec, inputFields, updater, new Fields(new String[0]));
    }

    public TridentState partitionPersist(StateFactory stateFactory, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(new StateSpec(stateFactory), updater, functionFields);
    }

    public TridentState partitionPersist(StateSpec stateSpec, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(stateSpec, null, updater, functionFields);
    }

    public TridentState partitionPersist(StateFactory stateFactory, StateUpdater updater) {
        return this.partitionPersist(stateFactory, updater, new Fields(new String[0]));
    }

    public TridentState partitionPersist(StateSpec stateSpec, StateUpdater updater) {
        return this.partitionPersist(stateSpec, updater, new Fields(new String[0]));
    }

    public Stream filter(Filter filter) {
        return this.each(this.getOutputFields(), filter);
    }

    public Stream filter(Fields inputFields, Filter filter) {
        return this.each(inputFields, filter);
    }

    public Stream map(MapFunction function) {
        this.projectionValidation(this.getOutputFields());
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, this.getOutputFields(), this.getOutputFields(), new MapProcessor(this.getOutputFields(), new MapFunctionExecutor(function))));
    }

    public Stream map(MapFunction function, Fields outputFields) {
        this.projectionValidation(this.getOutputFields());
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, outputFields, outputFields, new MapProcessor(this.getOutputFields(), new MapFunctionExecutor(function))));
    }

    public Stream flatMap(FlatMapFunction function) {
        this.projectionValidation(this.getOutputFields());
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, this.getOutputFields(), this.getOutputFields(), new MapProcessor(this.getOutputFields(), new FlatMapFunctionExecutor(function))));
    }

    public Stream flatMap(FlatMapFunction function, Fields outputFields) {
        this.projectionValidation(this.getOutputFields());
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, outputFields, outputFields, new MapProcessor(this.getOutputFields(), new FlatMapFunctionExecutor(function))));
    }

    public Stream peek(Consumer action) {
        this.projectionValidation(this.getOutputFields());
        return this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, this.getOutputFields(), this.getOutputFields(), new MapProcessor(this.getOutputFields(), new ConsumerExecutor(action))));
    }

    public ChainedAggregatorDeclarer chainedAgg() {
        return new ChainedAggregatorDeclarer(this, new BatchGlobalAggScheme());
    }

    public Stream minBy(String inputFieldName) {
        Min min = new Min(inputFieldName);
        return this.comparableAggregateStream(inputFieldName, min);
    }

    public <T> Stream minBy(String inputFieldName, Comparator<T> comparator) {
        MinWithComparator<T> min = new MinWithComparator<T>(inputFieldName, comparator);
        return this.comparableAggregateStream(inputFieldName, min);
    }

    public Stream min(Comparator<TridentTuple> comparator) {
        MinWithComparator<TridentTuple> min = new MinWithComparator<TridentTuple>(comparator);
        return this.comparableAggregateStream(null, min);
    }

    public Stream maxBy(String inputFieldName) {
        Max max = new Max(inputFieldName);
        return this.comparableAggregateStream(inputFieldName, max);
    }

    public <T> Stream maxBy(String inputFieldName, Comparator<T> comparator) {
        MaxWithComparator<T> max = new MaxWithComparator<T>(inputFieldName, comparator);
        return this.comparableAggregateStream(inputFieldName, max);
    }

    public Stream max(Comparator<TridentTuple> comparator) {
        MaxWithComparator<TridentTuple> max = new MaxWithComparator<TridentTuple>(comparator);
        return this.comparableAggregateStream(null, max);
    }

    private <T> Stream comparableAggregateStream(String inputFieldName, Aggregator<T> aggregator) {
        if (inputFieldName != null) {
            this.projectionValidation(new Fields(inputFieldName));
        }
        return this.partitionAggregate(this.getOutputFields(), aggregator, this.getOutputFields());
    }

    public Stream aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream tumblingWindow(int windowCount, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        return this.window(TumblingCountWindow.of(windowCount), windowStoreFactory, inputFields, aggregator, functionFields);
    }

    public Stream tumblingWindow(BaseWindowedBolt.Duration windowDuration, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        return this.window(TumblingDurationWindow.of(windowDuration), windowStoreFactory, inputFields, aggregator, functionFields);
    }

    public Stream slidingWindow(int windowCount, int slideCount, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        return this.window(SlidingCountWindow.of(windowCount, slideCount), windowStoreFactory, inputFields, aggregator, functionFields);
    }

    public Stream slidingWindow(BaseWindowedBolt.Duration windowDuration, BaseWindowedBolt.Duration slidingInterval, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        return this.window(SlidingDurationWindow.of(windowDuration, slidingInterval), windowStoreFactory, inputFields, aggregator, functionFields);
    }

    public Stream window(WindowConfig windowConfig, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        InMemoryWindowsStoreFactory inMemoryWindowsStoreFactory = new InMemoryWindowsStoreFactory();
        return this.window(windowConfig, inMemoryWindowsStoreFactory, inputFields, aggregator, functionFields, false);
    }

    public Stream window(WindowConfig windowConfig, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields) {
        return this.window(windowConfig, windowStoreFactory, inputFields, aggregator, functionFields, true);
    }

    private Stream window(WindowConfig windowConfig, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, Fields functionFields, boolean storeTuplesInStore) {
        this.projectionValidation(inputFields);
        windowConfig.validate();
        Fields fields = this.addTriggerField(functionFields);
        Stream stream = this.topology.addSourcedNode(this, (Node)new ProcessorNode(this.topology.getUniqueStreamId(), this.name, fields, fields, new WindowTridentProcessor(windowConfig, this.topology.getUniqueWindowId(), windowStoreFactory, inputFields, aggregator, storeTuplesInStore)));
        Stream effectiveStream = stream.project(functionFields);
        WindowsStateFactory stateFactory = new WindowsStateFactory();
        WindowsStateUpdater stateUpdater = new WindowsStateUpdater(windowStoreFactory);
        stream.partitionPersist(stateFactory, new Fields("_task_info"), (StateUpdater)stateUpdater, new Fields(new String[0]));
        return effectiveStream;
    }

    private Fields addTriggerField(Fields functionFields) {
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.add("_task_info");
        for (String field : functionFields) {
            fieldsList.add(field);
        }
        return new Fields(fieldsList);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return new ChainedAggregatorDeclarer(this, new GlobalAggScheme()).aggregate(inputFields, agg, functionFields).chainEnd().partitionPersist(spec, functionFields, (StateUpdater)new CombinerAggStateUpdater(agg), functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.global().partitionPersist(spec, inputFields, (StateUpdater)new ReducerAggStateUpdater(agg), functionFields);
    }

    @Override
    public Stream toStream() {
        return this;
    }

    @Override
    public Fields getOutputFields() {
        return this.node.allOutputFields;
    }

    private void projectionValidation(Fields projFields) {
        if (projFields == null) {
            return;
        }
        Fields allFields = this.getOutputFields();
        for (String field : projFields) {
            if (allFields.contains(field)) continue;
            throw new IllegalArgumentException("Trying to select non-existent field: '" + field + "' from stream containing fields fields: <" + allFields + ">");
        }
    }

    static class GlobalAggScheme
    implements GlobalAggregationScheme<Stream> {
        GlobalAggScheme() {
        }

        @Override
        public IAggregatableStream aggPartition(Stream s) {
            return s.global();
        }

        @Override
        public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
            return new GlobalBatchToPartition();
        }
    }

    static class BatchGlobalAggScheme
    implements GlobalAggregationScheme<Stream> {
        BatchGlobalAggScheme() {
        }

        @Override
        public IAggregatableStream aggPartition(Stream s) {
            return s.batchGlobal();
        }

        @Override
        public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
            return new IndexHashBatchToPartition();
        }
    }
}

