/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.io.Serializable;

public final class Pair<T1, T2>
implements Serializable {
    public final T1 value1;
    public final T2 value2;

    private Pair(T1 first, T2 second) {
        this.value1 = first;
        this.value2 = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public T1 getFirst() {
        return this.value1;
    }

    public T2 getSecond() {
        return this.value2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.value1 != null ? !this.value1.equals(pair.value1) : pair.value1 != null) {
            return false;
        }
        return this.value2 != null ? this.value2.equals(pair.value2) : pair.value2 == null;
    }

    public int hashCode() {
        int result2 = this.value1 != null ? this.value1.hashCode() : 0;
        result2 = 31 * result2 + (this.value2 != null ? this.value2.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "(" + this.value1 + ", " + this.value2 + ')';
    }
}

