/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import com.codahale.metrics.Counter;
import java.util.Map;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;

public abstract class CommonStats {
    protected final int rate;
    private final MultiCountStatAndMetric emittedStats;
    private final MultiCountStatAndMetric transferredStats;
    private final MultiCountStatAndMetric ackedStats;
    private final MultiCountStatAndMetric failedStats;

    public CommonStats(int rate, int numStatBuckets) {
        this.rate = rate;
        this.emittedStats = new MultiCountStatAndMetric(numStatBuckets);
        this.transferredStats = new MultiCountStatAndMetric(numStatBuckets);
        this.ackedStats = new MultiCountStatAndMetric(numStatBuckets);
        this.failedStats = new MultiCountStatAndMetric(numStatBuckets);
    }

    public MultiCountStatAndMetric getFailed() {
        return this.failedStats;
    }

    public MultiCountStatAndMetric getAcked() {
        return this.ackedStats;
    }

    public int getRate() {
        return this.rate;
    }

    public MultiCountStatAndMetric getEmitted() {
        return this.emittedStats;
    }

    public MultiCountStatAndMetric getTransferred() {
        return this.transferredStats;
    }

    public void emittedTuple(String stream, Counter emittedCounter) {
        this.getEmitted().incBy(stream, this.rate);
        emittedCounter.inc((long)this.rate);
    }

    public void transferredTuples(String stream, int amount, Counter transferredCounter) {
        this.getTransferred().incBy(stream, this.rate * amount);
        transferredCounter.inc((long)amount);
    }

    public void cleanupStats() {
        this.emittedStats.close();
        this.transferredStats.close();
        this.ackedStats.close();
        this.failedStats.close();
    }

    protected Map<String, Map<String, Long>> valueStat(MultiCountStatAndMetric metric) {
        return metric.getTimeCounts();
    }

    protected Map<String, Map<String, Double>> valueStat(MultiLatencyStatAndMetric metric) {
        return metric.getTimeLatAvg();
    }

    public abstract ExecutorStats renderStats();
}

