/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.digest;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.storm.generated.WorkerToken;
import org.apache.storm.security.auth.digest.JassPasswordProvider;
import org.apache.storm.security.auth.sasl.SaslTransportPlugin;
import org.apache.storm.security.auth.sasl.SimpleSaslClientCallbackHandler;
import org.apache.storm.security.auth.sasl.SimpleSaslServerCallbackHandler;
import org.apache.storm.security.auth.workertoken.WorkerTokenAuthorizer;
import org.apache.storm.security.auth.workertoken.WorkerTokenClientCallbackHandler;
import org.apache.storm.thrift.transport.TSaslClientTransport;
import org.apache.storm.thrift.transport.TSaslServerTransport;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestSaslTransportPlugin
extends SaslTransportPlugin {
    public static final String DIGEST = "DIGEST-MD5";
    private static final Logger LOG = LoggerFactory.getLogger(DigestSaslTransportPlugin.class);
    private WorkerTokenAuthorizer workerTokenAuthorizer;

    @Override
    protected TTransportFactory getServerTransportFactory(boolean impersonationAllowed) throws IOException {
        if (this.workerTokenAuthorizer == null) {
            this.workerTokenAuthorizer = new WorkerTokenAuthorizer(this.conf, this.type);
        }
        SimpleSaslServerCallbackHandler serverCallbackHandler = new SimpleSaslServerCallbackHandler(impersonationAllowed, this.workerTokenAuthorizer, new JassPasswordProvider(this.loginConf));
        TSaslServerTransport.Factory factory = new TSaslServerTransport.Factory();
        factory.addServerDefinition(DIGEST, "storm_thrift_server", "localhost", null, (CallbackHandler)serverCallbackHandler);
        LOG.info("SASL DIGEST-MD5 transport factory will be used");
        return factory;
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws TTransportException, IOException {
        SimpleSaslClientCallbackHandler clientCallbackHandler;
        WorkerToken token = WorkerTokenClientCallbackHandler.findWorkerTokenInSubject(this.type);
        if (token != null) {
            clientCallbackHandler = new WorkerTokenClientCallbackHandler(token);
        } else if (this.loginConf != null) {
            AppConfigurationEntry[] configurationEntries = this.loginConf.getAppConfigurationEntry("StormClient");
            if (configurationEntries == null) {
                String errorMessage = "Could not find a 'StormClient' entry in this configuration: Client cannot start.";
                throw new IOException(errorMessage);
            }
            String username = "";
            String password = "";
            for (AppConfigurationEntry entry : configurationEntries) {
                Map<String, ?> options = entry.getOptions();
                username = options.getOrDefault("username", username);
                password = options.getOrDefault("password", password);
            }
            clientCallbackHandler = new SimpleSaslClientCallbackHandler(username, password);
        } else {
            throw new IOException("Could not find any way to authenticate with the server.");
        }
        TSaslClientTransport wrapperTransport = new TSaslClientTransport(DIGEST, null, "storm_thrift_server", serverHost, null, (CallbackHandler)clientCallbackHandler, transport);
        wrapperTransport.open();
        LOG.debug("SASL DIGEST-MD5 client transport has been established");
        return wrapperTransport;
    }

    @Override
    public boolean areWorkerTokensSupported() {
        return true;
    }

    @Override
    public void close() {
        this.workerTokenAuthorizer.close();
    }
}

