/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.shade.com.google.common.collect.Maps;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;

public class PartialKeyGrouping
implements CustomStreamGrouping,
Serializable {
    private static final long serialVersionUID = -1672360572274911808L;
    private List<Integer> targetTasks;
    private Fields fields = null;
    private Fields outFields = null;
    private AssignmentCreator assignmentCreator;
    private TargetSelector targetSelector;

    public PartialKeyGrouping() {
        this(null);
    }

    public PartialKeyGrouping(Fields fields) {
        this(fields, new RandomTwoTaskAssignmentCreator(), new BalancedTargetSelector());
    }

    public PartialKeyGrouping(Fields fields, AssignmentCreator assignmentCreator) {
        this(fields, assignmentCreator, new BalancedTargetSelector());
    }

    public PartialKeyGrouping(Fields fields, AssignmentCreator assignmentCreator, TargetSelector targetSelector) {
        this.fields = fields;
        this.assignmentCreator = assignmentCreator;
        this.targetSelector = targetSelector;
    }

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.targetTasks = targetTasks;
        if (this.fields != null) {
            this.outFields = context.getComponentOutputFields(stream);
        }
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        ArrayList<Integer> boltIds = new ArrayList<Integer>(1);
        if (values.size() > 0) {
            byte[] rawKeyBytes = this.getKeyBytes(values);
            int[] taskAssignmentForKey = this.assignmentCreator.createAssignment(this.targetTasks, rawKeyBytes);
            int selectedTask = this.targetSelector.chooseTask(taskAssignmentForKey);
            boltIds.add(selectedTask);
        }
        return boltIds;
    }

    private byte[] getKeyBytes(List<Object> values) {
        byte[] raw;
        if (this.fields != null) {
            List<Object> selectedFields = this.outFields.select(this.fields, values);
            ByteBuffer out = ByteBuffer.allocate(selectedFields.size() * 4);
            for (Object o : selectedFields) {
                if (o instanceof List) {
                    out.putInt(Arrays.deepHashCode(((List)o).toArray()));
                    continue;
                }
                if (o instanceof Object[]) {
                    out.putInt(Arrays.deepHashCode((Object[])o));
                    continue;
                }
                if (o instanceof byte[]) {
                    out.putInt(Arrays.hashCode((byte[])o));
                    continue;
                }
                if (o instanceof short[]) {
                    out.putInt(Arrays.hashCode((short[])o));
                    continue;
                }
                if (o instanceof int[]) {
                    out.putInt(Arrays.hashCode((int[])o));
                    continue;
                }
                if (o instanceof long[]) {
                    out.putInt(Arrays.hashCode((long[])o));
                    continue;
                }
                if (o instanceof char[]) {
                    out.putInt(Arrays.hashCode((char[])o));
                    continue;
                }
                if (o instanceof float[]) {
                    out.putInt(Arrays.hashCode((float[])o));
                    continue;
                }
                if (o instanceof double[]) {
                    out.putInt(Arrays.hashCode((double[])o));
                    continue;
                }
                if (o instanceof boolean[]) {
                    out.putInt(Arrays.hashCode((boolean[])o));
                    continue;
                }
                if (o != null) {
                    out.putInt(o.hashCode());
                    continue;
                }
                out.putInt(0);
            }
            raw = out.array();
        } else {
            raw = values.get(0).toString().getBytes();
        }
        return raw;
    }

    public static class BalancedTargetSelector
    implements TargetSelector {
        private Map<Integer, Long> targetTaskStats = Maps.newHashMap();

        @Override
        public Integer chooseTask(int[] assignedTasks) {
            Integer taskIdWithMinLoad = null;
            Long minTaskLoad = Long.MAX_VALUE;
            int[] nArray = assignedTasks;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer currentTaskId = nArray[i];
                Long currentTaskLoad = this.targetTaskStats.getOrDefault(currentTaskId, 0L);
                if (currentTaskLoad >= minTaskLoad) continue;
                minTaskLoad = currentTaskLoad;
                taskIdWithMinLoad = currentTaskId;
            }
            this.targetTaskStats.put(taskIdWithMinLoad, this.targetTaskStats.getOrDefault(taskIdWithMinLoad, 0L) + 1L);
            return taskIdWithMinLoad;
        }
    }

    public static class RandomTwoTaskAssignmentCreator
    implements AssignmentCreator {
        @Override
        public int[] createAssignment(List<Integer> tasks, byte[] key) {
            int choice2;
            long seedForRandom = Arrays.hashCode(key);
            Random random = new Random(seedForRandom);
            int choice1 = random.nextInt(tasks.size());
            choice2 = choice1 == (choice2 = random.nextInt(tasks.size())) ? (choice2 + 1) % tasks.size() : choice2;
            return new int[]{tasks.get(choice1), tasks.get(choice2)};
        }
    }

    public static interface TargetSelector
    extends Serializable {
        public Integer chooseTask(int[] var1);
    }

    public static interface AssignmentCreator
    extends Serializable {
        public int[] createAssignment(List<Integer> var1, byte[] var2);
    }
}

