/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.BeginDownloadResult;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ListBlobsResult;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusBlobStore
extends ClientBlobStore
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusBlobStore.class);
    private NimbusClient client;
    private int bufferSize = 4096;

    @Override
    public void prepare(Map<String, Object> conf) {
        this.client = NimbusClient.getConfiguredClient(conf);
        if (conf != null) {
            this.bufferSize = ObjectReader.getInt(conf.get("storm.blobstore.inputstream.buffer.size.bytes"), this.bufferSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AtomicOutputStream createBlobToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                return new NimbusUploadAtomicOutputStream(this.client.getClient().beginCreateBlob(key, meta), this.bufferSize, key);
            }
        }
        catch (AuthorizationException | KeyAlreadyExistsException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicOutputStream updateBlob(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                return new NimbusUploadAtomicOutputStream(this.client.getClient().beginUpdateBlob(key), this.bufferSize, key);
            }
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                return this.client.getClient().getBlobMeta(key);
            }
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRemoteBlobExists(String blobKey) throws AuthorizationException {
        try {
            return this.client.getClient().isRemoteBlobExists(blobKey);
        }
        catch (AuthorizationException aze) {
            throw aze;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlobMetaToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                this.client.getClient().setBlobMeta(key, meta);
            }
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                this.client.getClient().deleteBlob(key);
            }
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStateInZookeeper(String key) {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                this.client.getClient().createStateInZookeeper(key);
            }
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamWithMeta getBlob(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                return new NimbusDownloadInputStream(this.client.getClient().beginBlobDownload(key));
            }
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> listKeys() {
        try {
            NimbusClient nimbusClient = this.client;
            synchronized (nimbusClient) {
                return new NimbusKeyIterator(this.client.getClient().listBlobs(""));
            }
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            return this.client.getClient().getBlobReplication(key);
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException {
        try {
            return this.client.getClient().updateBlobReplication(key, replication);
        }
        catch (AuthorizationException | KeyNotFoundException exp) {
            throw exp;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean setClient(Map<String, Object> conf, NimbusClient client) {
        if (this.client != null) {
            this.client.close();
        }
        this.client = client;
        if (conf != null) {
            this.bufferSize = ObjectReader.getInt(conf.get("storm.blobstore.inputstream.buffer.size.bytes"), this.bufferSize);
        }
        return true;
    }

    protected void finalize() {
        this.shutdown();
    }

    @Override
    public void shutdown() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public class NimbusUploadAtomicOutputStream
    extends AtomicOutputStream {
        private String session;
        private int maxChunkSize = 4096;
        private String key;

        public NimbusUploadAtomicOutputStream(String session, int bufferSize, String key) {
            this.session = session;
            this.maxChunkSize = bufferSize;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() throws IOException {
            try {
                NimbusClient nimbusClient = NimbusBlobStore.this.client;
                synchronized (nimbusClient) {
                    NimbusBlobStore.this.client.getClient().cancelBlobUpload(this.session);
                }
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            try {
                NimbusClient nimbusClient = NimbusBlobStore.this.client;
                synchronized (nimbusClient) {
                    NimbusBlobStore.this.client.getClient().uploadBlobChunk(this.session, ByteBuffer.wrap(new byte[]{(byte)b}));
                }
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            try {
                int end = offset + len;
                for (int realOffset = offset; realOffset < end; realOffset += this.maxChunkSize) {
                    int realLen = Math.min(end - realOffset, this.maxChunkSize);
                    LOG.debug("Writing {} bytes of {} remaining", (Object)realLen, (Object)(end - realOffset));
                    NimbusClient nimbusClient = NimbusBlobStore.this.client;
                    synchronized (nimbusClient) {
                        NimbusBlobStore.this.client.getClient().uploadBlobChunk(this.session, ByteBuffer.wrap(b, realOffset, realLen));
                        continue;
                    }
                }
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                NimbusClient nimbusClient = NimbusBlobStore.this.client;
                synchronized (nimbusClient) {
                    NimbusBlobStore.this.client.getClient().finishBlobUpload(this.session);
                    NimbusBlobStore.this.client.getClient().createStateInZookeeper(this.key);
                }
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class NimbusDownloadInputStream
    extends InputStreamWithMeta {
        private BeginDownloadResult beginBlobDownload;
        private byte[] buffer = null;
        private int offset = 0;
        private int end = 0;
        private boolean eof = false;

        public NimbusDownloadInputStream(BeginDownloadResult beginBlobDownload2) {
            this.beginBlobDownload = beginBlobDownload2;
        }

        @Override
        public long getVersion() throws IOException {
            return this.beginBlobDownload.get_version();
        }

        @Override
        public synchronized int read() throws IOException {
            try {
                int length;
                if (this.isEmpty()) {
                    this.readMore();
                    if (this.eof) {
                        return -1;
                    }
                }
                if ((length = Math.min(1, this.available())) == 0) {
                    return -1;
                }
                byte ret = this.buffer[this.offset];
                this.offset += length;
                return ret;
            }
            catch (TException exp) {
                throw new IOException(exp);
            }
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                if (this.isEmpty()) {
                    this.readMore();
                    if (this.eof) {
                        return -1;
                    }
                }
                int length = Math.min(len, this.available());
                System.arraycopy(this.buffer, this.offset, b, off, length);
                this.offset += length;
                return length;
            }
            catch (TException exp) {
                throw new IOException(exp);
            }
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        private boolean isEmpty() {
            return this.buffer == null || this.offset >= this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMore() throws TException {
            if (!this.eof) {
                ByteBuffer buff;
                NimbusClient nimbusClient = NimbusBlobStore.this.client;
                synchronized (nimbusClient) {
                    buff = NimbusBlobStore.this.client.getClient().downloadBlobChunk(this.beginBlobDownload.get_session());
                }
                this.buffer = buff.array();
                this.offset = buff.arrayOffset() + buff.position();
                int length = buff.remaining();
                this.end = this.offset + length;
                if (length == 0) {
                    this.eof = true;
                }
            }
        }

        @Override
        public synchronized int available() {
            return this.buffer == null ? 0 : this.end - this.offset;
        }

        @Override
        public long getFileLength() {
            return this.beginBlobDownload.get_data_size();
        }
    }

    public class NimbusKeyIterator
    implements Iterator<String> {
        private ListBlobsResult listBlobs = null;
        private int offset = 0;
        private boolean eof = false;

        public NimbusKeyIterator(ListBlobsResult listBlobs2) {
            this.listBlobs = listBlobs2;
            this.eof = listBlobs2.get_keys_size() == 0;
        }

        private boolean isCacheEmpty() {
            return this.listBlobs.get_keys_size() <= this.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMore() throws TException {
            if (!this.eof) {
                this.offset = 0;
                NimbusClient nimbusClient = NimbusBlobStore.this.client;
                synchronized (nimbusClient) {
                    this.listBlobs = NimbusBlobStore.this.client.getClient().listBlobs(this.listBlobs.get_session());
                }
                if (this.listBlobs.get_keys_size() == 0) {
                    this.eof = true;
                }
            }
        }

        @Override
        public synchronized boolean hasNext() {
            try {
                if (this.isCacheEmpty()) {
                    this.readMore();
                }
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
            return !this.eof;
        }

        @Override
        public synchronized String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String ret = this.listBlobs.get_keys().get(this.offset);
            ++this.offset;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Delete Not Supported");
        }
    }
}

