/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.NimbusPrincipal;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.utils.WrappedAuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreAclHandler {
    public static final Logger LOG = LoggerFactory.getLogger(BlobStoreAclHandler.class);
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int ADMIN = 4;
    public static final List<AccessControl> WORLD_EVERYTHING = Arrays.asList(new AccessControl(AccessControlType.OTHER, 7));
    public static final List<AccessControl> DEFAULT = new ArrayList<AccessControl>();
    private final IPrincipalToLocal ptol;
    private final IGroupMappingServiceProvider groupMappingServiceProvider;
    private Set<String> supervisors;
    private Set<String> admins;
    private Set<String> adminsGroups;
    private boolean doAclValidation;

    public BlobStoreAclHandler(Map<String, Object> conf) {
        this.ptol = ClientAuthUtils.getPrincipalToLocalPlugin(conf);
        this.groupMappingServiceProvider = conf.get("storm.group.mapping.service") != null ? ClientAuthUtils.getGroupMappingServiceProviderPlugin(conf) : null;
        this.supervisors = new HashSet<String>();
        this.admins = new HashSet<String>();
        this.adminsGroups = new HashSet<String>();
        if (conf.containsKey("nimbus.supervisor.users")) {
            this.supervisors.addAll((List)conf.get("nimbus.supervisor.users"));
        }
        if (conf.containsKey("nimbus.admins")) {
            this.admins.addAll((List)conf.get("nimbus.admins"));
        }
        if (conf.containsKey("nimbus.admins.groups")) {
            this.adminsGroups.addAll((List)conf.get("nimbus.admins.groups"));
        }
        if (conf.containsKey("storm.blobstore.acl.validation.enabled")) {
            this.doAclValidation = (Boolean)conf.get("storm.blobstore.acl.validation.enabled");
        }
    }

    private static AccessControlType parseAclType(String type) {
        if ("other".equalsIgnoreCase(type) || "o".equalsIgnoreCase(type)) {
            return AccessControlType.OTHER;
        }
        if ("user".equalsIgnoreCase(type) || "u".equalsIgnoreCase(type)) {
            return AccessControlType.USER;
        }
        throw new IllegalArgumentException(type + " is not a valid access control type");
    }

    private static int parseAccess(String access) {
        int ret = 0;
        for (char c : access.toCharArray()) {
            if ('r' == c) {
                ret |= 1;
                continue;
            }
            if ('w' == c) {
                ret |= 2;
                continue;
            }
            if ('a' == c) {
                ret |= 4;
                continue;
            }
            if ('-' == c) continue;
            throw new IllegalArgumentException("");
        }
        return ret;
    }

    public static AccessControl parseAccessControl(String str) {
        String[] parts = str.split(":");
        String type = "other";
        String name = "";
        String access = "-";
        if (parts.length > 3) {
            throw new IllegalArgumentException("Don't know how to parse " + str + " into an ACL value");
        }
        if (parts.length == 1) {
            type = "other";
            name = "";
            access = parts[0];
        } else if (parts.length == 2) {
            type = "user";
            name = parts[0];
            access = parts[1];
        } else if (parts.length == 3) {
            type = parts[0];
            name = parts[1];
            access = parts[2];
        }
        AccessControl ret = new AccessControl();
        ret.set_type(BlobStoreAclHandler.parseAclType(type));
        ret.set_name(name);
        ret.set_access(BlobStoreAclHandler.parseAccess(access));
        return ret;
    }

    private static String accessToString(int access) {
        StringBuilder ret = new StringBuilder();
        ret.append((access & 1) > 0 ? "r" : "-");
        ret.append((access & 2) > 0 ? "w" : "-");
        ret.append((access & 4) > 0 ? "a" : "-");
        return ret.toString();
    }

    public static String accessControlToString(AccessControl ac) {
        StringBuilder ret = new StringBuilder();
        switch (ac.get_type()) {
            case OTHER: {
                ret.append("o");
                break;
            }
            case USER: {
                ret.append("u");
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know what a type of " + (Object)((Object)ac.get_type()) + " means ");
            }
        }
        ret.append(":");
        if (ac.is_set_name()) {
            ret.append(ac.get_name());
        }
        ret.append(":");
        ret.append(BlobStoreAclHandler.accessToString(ac.get_access()));
        return ret.toString();
    }

    public static void validateSettableACLs(String key, List<AccessControl> acls) throws AuthorizationException {
        HashSet<String> aclUsers = new HashSet<String>();
        ArrayList<String> duplicateUsers = new ArrayList<String>();
        for (AccessControl acl : acls) {
            String aclUser = acl.get_name();
            if (StringUtils.isEmpty((String)aclUser) || aclUsers.add(aclUser)) continue;
            LOG.error("'{}' user can't appear more than once in the ACLs", (Object)aclUser);
            duplicateUsers.add(aclUser);
        }
        if (duplicateUsers.size() > 0) {
            String errorMessage = "user " + Arrays.toString(duplicateUsers.toArray()) + " can't appear more than once in the ACLs for key [" + key + "].";
            throw new WrappedAuthorizationException(errorMessage);
        }
    }

    private Set<String> constructUserFromPrincipals(Subject who) {
        HashSet<String> user = new HashSet<String>();
        if (who != null) {
            for (Principal p : who.getPrincipals()) {
                user.add(this.ptol.toLocal(p));
            }
        }
        return user;
    }

    private boolean isAdmin(Subject who) {
        Set<String> user = this.constructUserFromPrincipals(who);
        for (String u : user) {
            if (this.admins.contains(u)) {
                return true;
            }
            if (this.adminsGroups.size() <= 0 || this.groupMappingServiceProvider == null) continue;
            Set<String> userGroups = null;
            try {
                userGroups = this.groupMappingServiceProvider.getGroups(u);
            }
            catch (IOException e) {
                LOG.warn("Error while trying to fetch user groups", (Throwable)e);
            }
            if (userGroups == null) continue;
            for (String tgroup : userGroups) {
                if (!this.adminsGroups.contains(tgroup)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReadOperation(int operation) {
        return operation == 1;
    }

    private boolean isSupervisor(Subject who, int operation) {
        Set<String> user = this.constructUserFromPrincipals(who);
        if (this.isReadOperation(operation)) {
            for (String u : user) {
                if (!this.supervisors.contains(u)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNimbus(Subject who) {
        boolean isNimbusInstance = false;
        if (who != null) {
            Set<Principal> principals = who.getPrincipals();
            for (Principal principal : principals) {
                if (!(principal instanceof NimbusPrincipal)) continue;
                isNimbusInstance = true;
            }
        }
        return isNimbusInstance;
    }

    public boolean checkForValidUsers(Subject who, int mask) {
        return this.isNimbus(who) || this.isAdmin(who) || this.isSupervisor(who, mask);
    }

    public void validateUserCanReadMeta(List<AccessControl> acl, Subject who, String key) throws AuthorizationException {
        this.hasAnyPermissions(acl, 7, who, key);
    }

    public void hasAnyPermissions(List<AccessControl> acl, int mask, Subject who, String key) throws AuthorizationException {
        if (!this.doAclValidation) {
            return;
        }
        Set<String> user = this.constructUserFromPrincipals(who);
        LOG.debug("user {}", user);
        if (this.checkForValidUsers(who, mask)) {
            return;
        }
        for (AccessControl ac : acl) {
            int allowed = this.getAllowed(ac, user);
            LOG.debug(" user: {} allowed: {} key: {}", new Object[]{user, allowed, key});
            if ((allowed & mask) <= 0) continue;
            return;
        }
        throw new WrappedAuthorizationException(user + " does not have access to " + key);
    }

    public void hasPermissions(List<AccessControl> acl, int mask, Subject who, String key) throws AuthorizationException {
        if (!this.doAclValidation) {
            return;
        }
        Set<String> user = this.constructUserFromPrincipals(who);
        LOG.debug("user {}", user);
        if (this.checkForValidUsers(who, mask)) {
            return;
        }
        for (AccessControl ac : acl) {
            int allowed = this.getAllowed(ac, user);
            mask = ~allowed & mask;
            LOG.debug(" user: {} allowed: {} disallowed: {} key: {}", new Object[]{user, allowed, mask, key});
        }
        if (mask == 0) {
            return;
        }
        throw new WrappedAuthorizationException(user + " does not have " + this.namedPerms(mask) + " access to " + key);
    }

    public void normalizeSettableBlobMeta(String key, SettableBlobMeta meta, Subject who, int opMask) {
        meta.set_acl(this.normalizeSettableAcls(key, meta.get_acl(), who, opMask));
    }

    private String namedPerms(int mask) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        if ((mask & 1) > 0) {
            b.append("READ ");
        }
        if ((mask & 2) > 0) {
            b.append("WRITE ");
        }
        if ((mask & 4) > 0) {
            b.append("ADMIN ");
        }
        b.append("]");
        return b.toString();
    }

    private int getAllowed(AccessControl ac, Set<String> users) {
        switch (ac.get_type()) {
            case OTHER: {
                return ac.get_access();
            }
            case USER: {
                if (users.contains(ac.get_name())) {
                    return ac.get_access();
                }
                return 0;
            }
        }
        return 0;
    }

    private List<AccessControl> removeBadAcls(List<AccessControl> accessControls) {
        ArrayList<AccessControl> resultAcl = new ArrayList<AccessControl>();
        for (AccessControl control : accessControls) {
            if (control.get_type().equals((Object)AccessControlType.OTHER) && control.get_access() == 0) {
                LOG.debug("Removing invalid blobstore world ACL " + BlobStoreAclHandler.accessControlToString(control));
                continue;
            }
            resultAcl.add(control);
        }
        return resultAcl;
    }

    private final List<AccessControl> normalizeSettableAcls(String key, List<AccessControl> acls, Subject who, int opMask) {
        List<AccessControl> cleanAcls = this.removeBadAcls(acls);
        Set<String> userNames = this.getUserNamesFromSubject(who);
        for (String user : userNames) {
            this.fixAclsForUser(cleanAcls, user, opMask);
        }
        this.fixEmptyNameACLForUsers(cleanAcls, userNames, opMask);
        if ((who == null || userNames.isEmpty()) && !this.worldEverything(acls)) {
            cleanAcls.addAll(WORLD_EVERYTHING);
            LOG.debug("Access Control for key {} is normalized to world everything {}", (Object)key, cleanAcls);
            if (!acls.isEmpty()) {
                LOG.warn("Access control for blob with key {} is normalized to WORLD_EVERYTHING", (Object)key);
            }
        }
        return cleanAcls;
    }

    private boolean worldEverything(List<AccessControl> acls) {
        boolean isWorldEverything = false;
        for (AccessControl acl : acls) {
            if (acl.get_type() != AccessControlType.OTHER || acl.get_access() != 7) continue;
            isWorldEverything = true;
            break;
        }
        return isWorldEverything;
    }

    private void fixAclsForUser(List<AccessControl> acls, String user, int mask) {
        boolean foundUserAcl = false;
        ArrayList<AccessControl> emptyUserAcls = new ArrayList<AccessControl>();
        for (AccessControl control : acls) {
            if (control.get_type() != AccessControlType.USER) continue;
            if (!control.is_set_name()) {
                emptyUserAcls.add(control);
                continue;
            }
            if (!control.get_name().equals(user)) continue;
            int currentAccess = control.get_access();
            if ((currentAccess & mask) != mask) {
                control.set_access(currentAccess | mask);
            }
            foundUserAcl = true;
        }
        if (!emptyUserAcls.isEmpty() && foundUserAcl) {
            acls.removeAll(emptyUserAcls);
        }
        if (emptyUserAcls.isEmpty() && !foundUserAcl) {
            AccessControl userAcl = new AccessControl();
            userAcl.set_type(AccessControlType.USER);
            userAcl.set_name(user);
            userAcl.set_access(mask);
            acls.add(userAcl);
        }
    }

    private void fixEmptyNameACLForUsers(List<AccessControl> acls, Set<String> users, int mask) {
        ArrayList<AccessControl> aclsToAdd = new ArrayList<AccessControl>();
        ArrayList<AccessControl> aclsToRemove = new ArrayList<AccessControl>();
        for (AccessControl control : acls) {
            if (control.get_type() != AccessControlType.USER || control.is_set_name()) continue;
            aclsToRemove.add(control);
            int currentAccess = control.get_access();
            if ((currentAccess & mask) != mask) {
                control.set_access(currentAccess | mask);
            }
            for (String user : users) {
                AccessControl copiedControl = new AccessControl(control);
                copiedControl.set_name(user);
                aclsToAdd.add(copiedControl);
            }
        }
        acls.removeAll(aclsToRemove);
        acls.addAll(aclsToAdd);
    }

    private Set<String> getUserNamesFromSubject(Subject who) {
        HashSet<String> user = new HashSet<String>();
        if (who != null) {
            for (Principal p : who.getPrincipals()) {
                user.add(this.ptol.toLocal(p));
            }
        }
        return user;
    }
}

