/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.datasource.socket;

import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.spout.Scheme;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlStreamsDataSource;
import org.apache.storm.sql.runtime.datasource.socket.bolt.SocketBolt;
import org.apache.storm.sql.runtime.datasource.socket.spout.SocketSpout;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;

public class SocketDataSourcesProvider
implements DataSourcesProvider {
    @Override
    public String scheme() {
        return "socket";
    }

    @Override
    public ISqlStreamsDataSource constructStreams(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            throw new RuntimeException("Port information is not available. URI: " + uri);
        }
        List<String> fieldNames = FieldInfoUtils.getFieldNames(fields);
        Scheme scheme = SerdeUtils.getScheme(inputFormatClass, properties, fieldNames);
        IOutputSerializer serializer = SerdeUtils.getSerializer(outputFormatClass, properties, fieldNames);
        return new SocketStreamsDataSource(host, port, scheme, serializer);
    }

    private static class SocketStreamsDataSource
    implements ISqlStreamsDataSource {
        private final String host;
        private final int port;
        private final Scheme scheme;
        private final IOutputSerializer serializer;

        SocketStreamsDataSource(String host, int port, Scheme scheme, IOutputSerializer serializer) {
            this.host = host;
            this.port = port;
            this.scheme = scheme;
            this.serializer = serializer;
        }

        @Override
        public IRichSpout getProducer() {
            return new SocketSpout(this.scheme, this.host, this.port);
        }

        @Override
        public IRichBolt getConsumer() {
            return new SocketBolt(this.serializer, this.host, this.port);
        }
    }
}

