/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.storm.shade.org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);

    public static void deleteRecursive(ZooKeeper zk, String pathRoot) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1);
        }
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot, AsyncCallback.VoidCallback cb, Object ctx) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting " + tree);
        LOG.debug("Deleting " + tree.size() + " subnodes ");
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1, cb, ctx);
        }
    }

    public static List<String> listSubTreeBFS(ZooKeeper zk, String pathRoot) throws KeeperException, InterruptedException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = zk.getChildren(node, false);
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }
}

