/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.handler.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.apache.storm.shade.io.netty.handler.ssl.OpenSslSession;
import org.apache.storm.shade.io.netty.util.internal.EmptyArrays;

abstract class ExtendedOpenSslSession
extends ExtendedSSLSession
implements OpenSslSession {
    private static final String[] LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS = new String[]{"SHA512withRSA", "SHA512withECDSA", "SHA384withRSA", "SHA384withECDSA", "SHA256withRSA", "SHA256withECDSA", "SHA224withRSA", "SHA224withECDSA", "SHA1withRSA", "SHA1withECDSA"};
    private final OpenSslSession wrapped;

    ExtendedOpenSslSession(OpenSslSession wrapped) {
        assert (!(wrapped instanceof ExtendedSSLSession));
        this.wrapped = wrapped;
    }

    public abstract List getRequestedServerNames();

    @Override
    public List<byte[]> getStatusResponses() {
        return Collections.emptyList();
    }

    @Override
    public void handshakeFinished() throws SSLException {
        this.wrapped.handshakeFinished();
    }

    @Override
    public void tryExpandApplicationBufferSize(int packetLengthDataOnly) {
        this.wrapped.tryExpandApplicationBufferSize(packetLengthDataOnly);
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return (String[])LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS.clone();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return EmptyArrays.EMPTY_STRINGS;
    }

    @Override
    public byte[] getId() {
        return this.wrapped.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    public long getCreationTime() {
        return this.wrapped.getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        return this.wrapped.getLastAccessedTime();
    }

    @Override
    public void invalidate() {
        this.wrapped.invalidate();
    }

    @Override
    public boolean isValid() {
        return this.wrapped.isValid();
    }

    @Override
    public void putValue(String s, Object o) {
        this.wrapped.putValue(s, o);
    }

    @Override
    public Object getValue(String s) {
        return this.wrapped.getValue(s);
    }

    @Override
    public void removeValue(String s) {
        this.wrapped.removeValue(s);
    }

    @Override
    public String[] getValueNames() {
        return this.wrapped.getValueNames();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerCertificates();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.wrapped.getLocalCertificates();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerCertificateChain();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.wrapped.getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.wrapped.getLocalPrincipal();
    }

    @Override
    public String getCipherSuite() {
        return this.wrapped.getCipherSuite();
    }

    @Override
    public String getProtocol() {
        return this.wrapped.getProtocol();
    }

    @Override
    public String getPeerHost() {
        return this.wrapped.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.wrapped.getPeerPort();
    }

    @Override
    public int getPacketBufferSize() {
        return this.wrapped.getPacketBufferSize();
    }

    @Override
    public int getApplicationBufferSize() {
        return this.wrapped.getApplicationBufferSize();
    }
}

