/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.storm.common.AbstractHadoopNimbusPluginAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHBaseNimbus
extends AbstractHadoopNimbusPluginAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHBaseNimbus.class);

    @Override
    public void doPrepare(Map<String, Object> conf) {
    }

    @Override
    protected String getConfigKeyString() {
        return "hbaseCredentialsConfigKeys";
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey, String topologyOwnerPrincipal) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration, topologyOwnerPrincipal);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String topologyOwnerPrincipal) {
        return this.getHadoopCredentials(conf, HBaseConfiguration.create(), topologyOwnerPrincipal);
    }

    protected byte[] getHadoopCredentials(Map<String, Object> conf, Configuration hbaseConf, String topologySubmitterUser) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                UserProvider provider = UserProvider.instantiate((Configuration)hbaseConf);
                provider.login("hbase.keytab.file", "hbase.kerberos.principal", InetAddress.getLocalHost().getCanonicalHostName());
                LOG.info("Logged into Hbase as principal = " + hbaseConf.get("hbase.kerberos.principal"));
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologySubmitterUser, (UserGroupInformation)ugi);
                User user = User.create((UserGroupInformation)proxyUser);
                if (User.isHBaseSecurityEnabled((Configuration)hbaseConf)) {
                    Connection connection = ConnectionFactory.createConnection((Configuration)hbaseConf, (User)user);
                    TokenUtil.obtainAndCacheToken((Connection)connection, (User)user);
                    LOG.info("Obtained HBase tokens, adding to user credentials.");
                    Credentials credential = proxyUser.getCredentials();
                    for (Token tokenForLog : credential.getAllTokens()) {
                        LOG.debug("Obtained token info in credential: {} / {}", (Object)tokenForLog.toString(), (Object)tokenForLog.decodeIdentifier().getUser());
                    }
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bao);
                    credential.write((DataOutput)out);
                    out.flush();
                    out.close();
                    return bao.toByteArray();
                }
                throw new RuntimeException("Security is not enabled for HBase.");
            }
            throw new RuntimeException("Security is not enabled for Hadoop");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    private Configuration getHadoopConfiguration(Map<String, Object> topoConf, String configKey) {
        Configuration configuration = HBaseConfiguration.create();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf, String topologySubmitterUser) {
        this.populateCredentials(credentials, topologyConf, topologySubmitterUser);
    }

    @Override
    public String getCredentialKey(String configKey) {
        return "HBASE_CREDENTIALS" + configKey;
    }
}

