/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class TridentOperationContext
implements IMetricsContext {
    TridentTuple.Factory factory;
    TopologyContext topoContext;

    public TridentOperationContext(TopologyContext topoContext, TridentTuple.Factory factory) {
        this.factory = factory;
        this.topoContext = topoContext;
    }

    public TridentOperationContext(TridentOperationContext parent, TridentTuple.Factory factory) {
        this(parent.topoContext, factory);
    }

    public TridentTupleView.ProjectionFactory makeProjectionFactory(Fields fields) {
        return new TridentTupleView.ProjectionFactory(this.factory, fields);
    }

    public int numPartitions() {
        return this.topoContext.getComponentTasks(this.topoContext.getThisComponentId()).size();
    }

    public int getPartitionIndex() {
        return this.topoContext.getThisTaskIndex();
    }

    @Override
    public <T extends IMetric> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        return this.topoContext.registerMetric(name, metric, timeBucketSizeInSecs);
    }

    @Override
    public ReducedMetric registerMetric(String name, IReducer reducer, int timeBucketSizeInSecs) {
        return this.topoContext.registerMetric(name, new ReducedMetric(reducer), timeBucketSizeInSecs);
    }

    @Override
    public CombinedMetric registerMetric(String name, ICombiner combiner, int timeBucketSizeInSecs) {
        return this.topoContext.registerMetric(name, new CombinedMetric(combiner), timeBucketSizeInSecs);
    }

    @Override
    public Timer registerTimer(String name) {
        return this.topoContext.registerTimer(name);
    }

    @Override
    public Histogram registerHistogram(String name) {
        return this.topoContext.registerHistogram(name);
    }

    @Override
    public Meter registerMeter(String name) {
        return this.topoContext.registerMeter(name);
    }

    @Override
    public Counter registerCounter(String name) {
        return this.topoContext.registerCounter(name);
    }

    @Override
    public <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return this.topoContext.registerGauge(name, gauge);
    }
}

