/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.shade.org.apache.commons.lang.NotImplementedException;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.state.ISubscribedState;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;

public class TopologyContext
extends WorkerTopologyContext
implements IMetricsContext {
    private final Integer taskId;
    private final Map<String, Object> taskData = new HashMap<String, Object>();
    private final List<ITaskHook> hooks = new ArrayList<ITaskHook>();
    private final Map<String, Object> executorData;
    private final Map<Integer, Map<Integer, Map<String, IMetric>>> registeredMetrics;
    private final AtomicBoolean openOrPrepareWasCalled;
    private final StormMetricRegistry metricRegistry;
    private final Map<String, Long> blobToLastKnownVersion;

    public TopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, Map<String, Long> blobToLastKnownVersionShared, String stormId, String codeDir, String pidDir, Integer taskId, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources, Map<String, Object> executorData, Map<Integer, Map<Integer, Map<String, IMetric>>> registeredMetrics, AtomicBoolean openOrPrepareWasCalled, StormMetricRegistry metricRegistry) {
        super(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId, codeDir, pidDir, workerPort, workerTasks, defaultResources, userResources);
        this.metricRegistry = metricRegistry;
        this.taskId = taskId;
        this.executorData = executorData;
        this.registeredMetrics = registeredMetrics;
        this.openOrPrepareWasCalled = openOrPrepareWasCalled;
        this.blobToLastKnownVersion = blobToLastKnownVersionShared;
    }

    private static Map<String, Object> groupingToJSONableMap(Grouping grouping) {
        HashMap<String, Object> groupingMap = new HashMap<String, Object>();
        groupingMap.put("type", ((Grouping._Fields)grouping.getSetField()).toString());
        if (grouping.is_set_fields()) {
            groupingMap.put("fields", grouping.get_fields());
        }
        return groupingMap;
    }

    public <T extends ISubscribedState> T setAllSubscribedState(T obj) {
        throw new NotImplementedException();
    }

    public <T extends ISubscribedState> T setSubscribedState(String componentId, T obj) {
        return this.setSubscribedState(componentId, "default", obj);
    }

    public <T extends ISubscribedState> T setSubscribedState(String componentId, String streamId, T obj) {
        throw new NotImplementedException();
    }

    public Map<String, Long> getBlobToLastKnownVersion() {
        return this.blobToLastKnownVersion;
    }

    public int getThisTaskId() {
        return this.taskId;
    }

    public String getThisComponentId() {
        return this.getComponentId(this.taskId);
    }

    public Fields getThisOutputFields(String streamId) {
        return this.getComponentOutputFields(this.getThisComponentId(), streamId);
    }

    public Map<String, List<String>> getThisOutputFieldsForStreams() {
        HashMap<String, List<String>> streamToFields = new HashMap<String, List<String>>();
        for (String stream : this.getThisStreams()) {
            streamToFields.put(stream, this.getThisOutputFields(stream).toList());
        }
        return streamToFields;
    }

    public Set<String> getThisStreams() {
        return this.getComponentStreams(this.getThisComponentId());
    }

    public int getThisTaskIndex() {
        ArrayList<Integer> tasks = new ArrayList<Integer>(this.getComponentTasks(this.getThisComponentId()));
        Collections.sort(tasks);
        for (int i = 0; i < tasks.size(); ++i) {
            if (((Integer)tasks.get(i)).intValue() != this.getThisTaskId()) continue;
            return i;
        }
        throw new RuntimeException("Fatal: could not find this task id in this component");
    }

    public Map<String, Map<String, List<String>>> getThisInputFields() {
        HashMap<String, Map<String, List<String>>> outputMap = new HashMap<String, Map<String, List<String>>>();
        for (Map.Entry<GlobalStreamId, Grouping> entry : this.getThisSources().entrySet()) {
            String componentId = entry.getKey().get_componentId();
            Set<String> streams = this.getComponentStreams(componentId);
            for (String stream : streams) {
                HashMap<String, List<String>> streamFieldMap = (HashMap<String, List<String>>)outputMap.get(componentId);
                if (streamFieldMap == null) {
                    streamFieldMap = new HashMap<String, List<String>>();
                    outputMap.put(componentId, streamFieldMap);
                }
                streamFieldMap.put(stream, this.getComponentOutputFields(componentId, stream).toList());
            }
        }
        return outputMap;
    }

    public Map<GlobalStreamId, Grouping> getThisSources() {
        return this.getSources(this.getThisComponentId());
    }

    public Map<String, Map<String, Grouping>> getThisTargets() {
        return this.getTargets(this.getThisComponentId());
    }

    public void setTaskData(String name, Object data) {
        this.taskData.put(name, data);
    }

    public Object getTaskData(String name) {
        return this.taskData.get(name);
    }

    public void setExecutorData(String name, Object data) {
        this.executorData.put(name, data);
    }

    public Object getExecutorData(String name) {
        return this.executorData.get(name);
    }

    public void addTaskHook(ITaskHook hook) {
        hook.prepare(this.topoConf, this);
        this.hooks.add(hook);
    }

    public List<ITaskHook> getHooks() {
        return this.hooks;
    }

    @Override
    public String toJSONString() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("task->component", this.getTaskToComponent());
        obj.put("taskid", this.getThisTaskId());
        obj.put("componentid", this.getThisComponentId());
        ArrayList<String> streamList = new ArrayList<String>();
        streamList.addAll(this.getThisStreams());
        obj.put("streams", streamList);
        obj.put("stream->outputfields", this.getThisOutputFieldsForStreams());
        HashMap stringTargets = new HashMap();
        for (Map.Entry<String, Map<String, Grouping>> entry : this.getThisTargets().entrySet()) {
            HashMap<String, Map<String, Object>> stringTargetMap = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Grouping> innerEntry : entry.getValue().entrySet()) {
                stringTargetMap.put(innerEntry.getKey(), TopologyContext.groupingToJSONableMap(innerEntry.getValue()));
            }
            stringTargets.put(entry.getKey(), stringTargetMap);
        }
        obj.put("stream->target->grouping", stringTargets);
        HashMap<String, HashMap<String, Map<String, Object>>> stringSources = new HashMap<String, HashMap<String, Map<String, Object>>>();
        for (Map.Entry<GlobalStreamId, Grouping> entry : this.getThisSources().entrySet()) {
            GlobalStreamId gid = entry.getKey();
            HashMap<String, Map<String, Object>> stringSourceMap = (HashMap<String, Map<String, Object>>)stringSources.get(gid.get_componentId());
            if (stringSourceMap == null) {
                stringSourceMap = new HashMap<String, Map<String, Object>>();
                stringSources.put(gid.get_componentId(), stringSourceMap);
            }
            stringSourceMap.put(gid.get_streamId(), TopologyContext.groupingToJSONableMap(entry.getValue()));
        }
        obj.put("source->stream->grouping", stringSources);
        obj.put("source->stream->fields", this.getThisInputFields());
        return JSONValue.toJSONString(obj);
    }

    @Override
    @Deprecated
    public <T extends IMetric> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        Map<String, IMetric> m3;
        Map<Integer, Map<String, IMetric>> m2;
        if (this.openOrPrepareWasCalled.get()) {
            throw new RuntimeException("TopologyContext.registerMetric can only be called from within overridden IBolt::prepare() or ISpout::open() method.");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Cannot register a null metric");
        }
        if (timeBucketSizeInSecs <= 0) {
            throw new IllegalArgumentException("TopologyContext.registerMetric can only be called with timeBucketSizeInSecs greater than or equal to 1 second.");
        }
        if (this.getRegisteredMetricByName(name) != null) {
            throw new RuntimeException("The same metric name `" + name + "` was registered twice.");
        }
        Map<Integer, Map<Integer, Map<String, IMetric>>> m1 = this.registeredMetrics;
        if (!m1.containsKey(timeBucketSizeInSecs)) {
            m1.put(timeBucketSizeInSecs, new HashMap());
        }
        if (!(m2 = m1.get(timeBucketSizeInSecs)).containsKey(this.taskId)) {
            m2.put(this.taskId, new HashMap());
        }
        if ((m3 = m2.get(this.taskId)).containsKey(name)) {
            throw new RuntimeException("The same metric name `" + name + "` was registered twice.");
        }
        m3.put(name, metric);
        return metric;
    }

    @Override
    @Deprecated
    public ReducedMetric registerMetric(String name, IReducer reducer, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new ReducedMetric(reducer), timeBucketSizeInSecs);
    }

    @Override
    @Deprecated
    public CombinedMetric registerMetric(String name, ICombiner combiner, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new CombinedMetric(combiner), timeBucketSizeInSecs);
    }

    @Deprecated
    public IMetric getRegisteredMetricByName(String name) {
        Map<Integer, Map<String, IMetric>> taskIdToNameToMetric;
        Map<String, IMetric> nameToMetric;
        IMetric metric = null;
        Iterator<Map<Integer, Map<String, IMetric>>> iterator = this.registeredMetrics.values().iterator();
        while (iterator.hasNext() && ((nameToMetric = (taskIdToNameToMetric = iterator.next()).get(this.taskId)) == null || (metric = nameToMetric.get(name)) == null)) {
        }
        return metric;
    }

    @Override
    public Timer registerTimer(String name) {
        return this.metricRegistry.registry().timer(this.metricName(name));
    }

    @Override
    public Histogram registerHistogram(String name) {
        return this.metricRegistry.registry().histogram(this.metricName(name));
    }

    @Override
    public Meter registerMeter(String name) {
        return this.metricRegistry.registry().meter(this.metricName(name));
    }

    @Override
    public Counter registerCounter(String name) {
        return this.metricRegistry.registry().counter(this.metricName(name));
    }

    @Override
    public <T> Gauge<T> registerGauge(String name, Gauge<T> gauge) {
        return (Gauge)this.metricRegistry.registry().register(this.metricName(name), gauge);
    }

    private String metricName(String name) {
        return this.metricRegistry.metricName(name, this);
    }
}

