/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleACLAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleACLAuthorizer.class);
    protected Set<String> userCommands = new HashSet<String>(Arrays.asList("submitTopology", "fileUpload", "getNimbusConf", "getClusterInfo", "getSupervisorPageInfo", "getOwnerResourceSummaries"));
    protected Set<String> supervisorCommands = new HashSet<String>(Arrays.asList("fileDownload", "processWorkerMetrics", "getSupervisorAssignments", "sendSupervisorWorkerHeartbeats"));
    protected Set<String> topoReadOnlyCommands = new HashSet<String>(Arrays.asList("getTopologyConf", "getTopology", "getUserTopology", "getTopologyInfo", "getTopologyPageInfo", "getComponentPageInfo", "getWorkerProfileActionExpiry", "getComponentPendingProfileActions", "getLogConfig"));
    protected Set<String> topoCommands = new HashSet<String>(Arrays.asList("killTopology", "rebalance", "activate", "deactivate", "uploadNewCredentials", "setLogConfig", "setWorkerProfiler", "startProfiling", "stopProfiling", "dumpProfile", "dumpJstack", "dumpHeap", "debug", "sendSupervisorWorkerHeartbeat"));
    protected Set<String> admins;
    protected Set<String> adminsGroups;
    protected Set<String> supervisors;
    protected Set<String> nimbusUsers;
    protected Set<String> nimbusGroups;
    protected IPrincipalToLocal ptol;
    protected IGroupMappingServiceProvider groupMappingServiceProvider;

    public SimpleACLAuthorizer() {
        this.topoCommands.addAll(this.topoReadOnlyCommands);
    }

    @Override
    public void prepare(Map<String, Object> conf) {
        this.admins = new HashSet<String>();
        this.adminsGroups = new HashSet<String>();
        this.supervisors = new HashSet<String>();
        this.nimbusUsers = new HashSet<String>();
        this.nimbusGroups = new HashSet<String>();
        if (conf.containsKey("nimbus.admins")) {
            this.admins.addAll((Collection)conf.get("nimbus.admins"));
        }
        if (conf.containsKey("nimbus.admins.groups")) {
            this.adminsGroups.addAll((Collection)conf.get("nimbus.admins.groups"));
        }
        if (conf.containsKey("nimbus.supervisor.users")) {
            this.supervisors.addAll((Collection)conf.get("nimbus.supervisor.users"));
        }
        if (conf.containsKey("nimbus.users")) {
            this.nimbusUsers.addAll((Collection)conf.get("nimbus.users"));
        }
        if (conf.containsKey("nimbus.groups")) {
            this.nimbusGroups.addAll((Collection)conf.get("nimbus.groups"));
        }
        this.ptol = ClientAuthUtils.getPrincipalToLocalPlugin(conf);
        this.groupMappingServiceProvider = ClientAuthUtils.getGroupMappingServiceProviderPlugin(conf);
    }

    @Override
    public boolean permit(ReqContext context, String operation, Map<String, Object> topoConf) {
        String principal = context.principal().getName();
        String user = this.ptol.toLocal(context.principal());
        HashSet<String> userGroups = new HashSet();
        if (this.groupMappingServiceProvider != null) {
            try {
                userGroups = this.groupMappingServiceProvider.getGroups(user);
            }
            catch (IOException e) {
                LOG.warn("Error while trying to fetch user groups", (Throwable)e);
            }
        }
        if (this.admins.contains(principal) || this.admins.contains(user) || this.checkUserGroupAllowed(userGroups, this.adminsGroups).booleanValue()) {
            return true;
        }
        if (this.supervisors.contains(principal) || this.supervisors.contains(user)) {
            return this.supervisorCommands.contains(operation);
        }
        if (this.userCommands.contains(operation)) {
            return this.nimbusUsers.size() == 0 || this.nimbusUsers.contains(user) || this.checkUserGroupAllowed(userGroups, this.nimbusGroups) != false;
        }
        if (this.topoCommands.contains(operation)) {
            if (this.checkTopoPermission(principal, user, userGroups, topoConf, "topology.users", "topology.groups").booleanValue()) {
                return true;
            }
            if (this.topoReadOnlyCommands.contains(operation) && this.checkTopoPermission(principal, user, userGroups, topoConf, "topology.readonly.users", "topology.readonly.groups").booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private Boolean checkTopoPermission(String principal, String user, Set<String> userGroups, Map<String, Object> topoConf, String userConfigKey, String groupConfigKey) {
        HashSet configuredUsers = new HashSet();
        if (topoConf.containsKey(userConfigKey)) {
            configuredUsers.addAll((Collection)topoConf.get(userConfigKey));
        }
        if (configuredUsers.contains(principal) || configuredUsers.contains(user)) {
            return true;
        }
        HashSet<String> configuredGroups = new HashSet<String>();
        if (topoConf.containsKey(groupConfigKey) && topoConf.get(groupConfigKey) != null) {
            configuredGroups.addAll((Collection)topoConf.get(groupConfigKey));
        }
        return this.checkUserGroupAllowed(userGroups, configuredGroups);
    }

    private Boolean checkUserGroupAllowed(Set<String> userGroups, Set<String> configuredGroups) {
        if (userGroups.size() > 0 && configuredGroups.size() > 0) {
            for (String tgroup : configuredGroups) {
                if (!userGroups.contains(tgroup)) continue;
                return true;
            }
        }
        return false;
    }
}

