/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.ScheduledReporter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.StormReporter;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledStormReporter
implements StormReporter {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledStormReporter.class);
    protected ScheduledReporter reporter;
    protected long reportingPeriod;
    protected TimeUnit reportingPeriodUnit;

    public static TimeUnit getReportPeriodUnit(Map<String, Object> reporterConf) {
        TimeUnit unit = ScheduledStormReporter.getTimeUnitForConfig(reporterConf, "report.period.units");
        return unit == null ? TimeUnit.SECONDS : unit;
    }

    private static TimeUnit getTimeUnitForConfig(Map reporterConf, String configName) {
        String rateUnitString = ObjectReader.getString(reporterConf.get(configName), null);
        if (rateUnitString != null) {
            return TimeUnit.valueOf(rateUnitString);
        }
        return null;
    }

    public static long getReportPeriod(Map reporterConf) {
        return ObjectReader.getInt(reporterConf.get("report.period"), 10).longValue();
    }

    public static StormMetricsFilter getMetricsFilter(Map reporterConf) {
        String clazz;
        StormMetricsFilter filter = null;
        Map filterConf = (Map)reporterConf.get("filter");
        if (filterConf != null && (clazz = (String)filterConf.get("class")) != null) {
            filter = (StormMetricsFilter)ReflectionUtils.newInstance(clazz);
            filter.prepare(filterConf);
        }
        return filter;
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start(this.reportingPeriod, this.reportingPeriodUnit);
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.stop();
    }
}

