/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;

public class SystemBolt
implements IBolt {
    private static boolean prepareWasCalled = false;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        if (prepareWasCalled && !"local".equals(topoConf.get("storm.cluster.mode"))) {
            throw new RuntimeException("A single worker should have 1 SystemBolt instance.");
        }
        prepareWasCalled = true;
        int bucketSize = ObjectReader.getInt(topoConf.get("topology.builtin.metrics.bucket.size.secs"));
        RuntimeMXBean jvmRt = ManagementFactory.getRuntimeMXBean();
        context.registerMetric("uptimeSecs", () -> (double)jvmRt.getUptime() / 1000.0, bucketSize);
        context.registerMetric("startTimeSecs", () -> (double)jvmRt.getStartTime() / 1000.0, bucketSize);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        context.registerMetric("threadCount", threadBean::getThreadCount, bucketSize);
        context.registerMetric("newWorkerEvent", new IMetric(){
            boolean doEvent = true;

            @Override
            public Object getValueAndReset() {
                if (this.doEvent) {
                    this.doEvent = false;
                    return 1;
                }
                return 0;
            }
        }, bucketSize);
        MemoryMXBean jvmMemRT = ManagementFactory.getMemoryMXBean();
        context.registerMetric("memory/heap", new MemoryUsageMetric(jvmMemRT::getHeapMemoryUsage), bucketSize);
        context.registerMetric("memory/nonHeap", new MemoryUsageMetric(jvmMemRT::getNonHeapMemoryUsage), bucketSize);
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            context.registerMetric("GC/" + b.getName().replaceAll("\\W", ""), new GarbageCollectorMetric(b), bucketSize);
        }
        this.registerMetrics(context, (Map)topoConf.get("worker.metrics"), bucketSize, topoConf);
        this.registerMetrics(context, (Map)topoConf.get("topology.worker.metrics"), bucketSize, topoConf);
    }

    private void registerMetrics(TopologyContext context, Map<String, String> metrics, int bucketSize, Map<String, Object> conf) {
        if (metrics == null) {
            return;
        }
        for (Map.Entry<String, String> metric : metrics.entrySet()) {
            try {
                context.registerMetric(metric.getKey(), (IMetric)ReflectionUtils.newInstance(metric.getValue(), conf), bucketSize);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void execute(Tuple input) {
        throw new RuntimeException("Non-system tuples should never be sent to __system bolt.");
    }

    @Override
    public void cleanup() {
    }

    private static class GarbageCollectorMetric
    implements IMetric {
        GarbageCollectorMXBean gcBean;
        Long collectionCount;
        Long collectionTime;

        public GarbageCollectorMetric(GarbageCollectorMXBean gcBean) {
            this.gcBean = gcBean;
        }

        @Override
        public Object getValueAndReset() {
            Long collectionCountP = this.gcBean.getCollectionCount();
            Long collectionTimeP = this.gcBean.getCollectionTime();
            HashMap<String, Long> ret = null;
            if (this.collectionCount != null && this.collectionTime != null) {
                ret = new HashMap<String, Long>();
                ret.put("count", collectionCountP - this.collectionCount);
                ret.put("timeMs", collectionTimeP - this.collectionTime);
            }
            this.collectionCount = collectionCountP;
            this.collectionTime = collectionTimeP;
            return ret;
        }
    }

    private static class MemoryUsageMetric
    implements IMetric {
        Supplier<MemoryUsage> getUsage;

        public MemoryUsageMetric(Supplier<MemoryUsage> getUsage) {
            this.getUsage = getUsage;
        }

        @Override
        public Object getValueAndReset() {
            MemoryUsage memUsage = this.getUsage.get();
            HashMap<String, Long> m = new HashMap<String, Long>();
            m.put("maxBytes", memUsage.getMax());
            m.put("committedBytes", memUsage.getCommitted());
            m.put("initBytes", memUsage.getInit());
            m.put("usedBytes", memUsage.getUsed());
            m.put("virtualFreeBytes", memUsage.getMax() - memUsage.getUsed());
            m.put("unusedBytes", memUsage.getCommitted() - memUsage.getUsed());
            return m;
        }
    }
}

