/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.util.Iterator;
import java.util.Map;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.utils.NimbusClient;

public class LocalModeClientBlobStore
extends ClientBlobStore {
    private final BlobStore wrapped;

    public LocalModeClientBlobStore(BlobStore wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void shutdown() {
        this.wrapped.shutdown();
    }

    @Override
    public void prepare(Map<String, Object> conf) {
    }

    @Override
    protected AtomicOutputStream createBlobToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
        return this.wrapped.createBlob(key, meta, null);
    }

    @Override
    public AtomicOutputStream updateBlob(String key) throws AuthorizationException, KeyNotFoundException {
        return this.wrapped.updateBlob(key, null);
    }

    @Override
    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException {
        return this.wrapped.getBlobMeta(key, null);
    }

    @Override
    public boolean isRemoteBlobExists(String blobKey) throws AuthorizationException {
        try {
            this.wrapped.getBlob(blobKey, null);
        }
        catch (KeyNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void setBlobMetaToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        this.wrapped.setBlobMeta(key, meta, null);
    }

    @Override
    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException {
        this.wrapped.deleteBlob(key, null);
    }

    @Override
    public InputStreamWithMeta getBlob(String key) throws AuthorizationException, KeyNotFoundException {
        return this.wrapped.getBlob(key, null);
    }

    @Override
    public Iterator<String> listKeys() {
        return this.wrapped.listKeys();
    }

    @Override
    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException {
        try {
            return this.wrapped.getBlobReplication(key, null);
        }
        catch (AuthorizationException | KeyNotFoundException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException {
        try {
            return this.wrapped.updateBlobReplication(key, replication, null);
        }
        catch (AuthorizationException | KeyNotFoundException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean setClient(Map<String, Object> conf, NimbusClient client) {
        return true;
    }

    @Override
    public void createStateInZookeeper(String key) {
    }

    @Override
    public void close() {
        this.wrapped.shutdown();
    }
}

