/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.JavaObject;
import org.apache.storm.generated.JavaObjectArg;
import org.apache.storm.generated.NullStruct;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.task.IBolt;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.SpoutDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thrift {
    private static Logger LOG = LoggerFactory.getLogger(Thrift.class);
    private static StormTopology._Fields[] STORM_TOPOLOGY_FIELDS = null;
    private static StormTopology._Fields[] SPOUT_FIELDS = new StormTopology._Fields[]{StormTopology._Fields.SPOUTS, StormTopology._Fields.STATE_SPOUTS};

    public static StormTopology._Fields[] getTopologyFields() {
        return STORM_TOPOLOGY_FIELDS;
    }

    public static StormTopology._Fields[] getSpoutFields() {
        return SPOUT_FIELDS;
    }

    public static StreamInfo directOutputFields(List<String> fields) {
        return new StreamInfo(fields, true);
    }

    public static StreamInfo outputFields(List<String> fields) {
        return new StreamInfo(fields, false);
    }

    public static Grouping prepareShuffleGrouping() {
        return Grouping.shuffle(new NullStruct());
    }

    public static Grouping prepareLocalOrShuffleGrouping() {
        return Grouping.local_or_shuffle(new NullStruct());
    }

    public static Grouping prepareFieldsGrouping(List<String> fields) {
        return Grouping.fields(fields);
    }

    public static Grouping prepareGlobalGrouping() {
        return Thrift.prepareFieldsGrouping(new ArrayList<String>());
    }

    public static Grouping prepareDirectGrouping() {
        return Grouping.direct(new NullStruct());
    }

    public static Grouping prepareAllGrouping() {
        return Grouping.all(new NullStruct());
    }

    public static Grouping prepareNoneGrouping() {
        return Grouping.none(new NullStruct());
    }

    public static Grouping prepareCustomStreamGrouping(Object obj) {
        return Grouping.custom_serialized(Utils.javaSerialize(obj));
    }

    public static Grouping prepareCustomJavaObjectGrouping(JavaObject obj) {
        return Grouping.custom_object(obj);
    }

    public static Object instantiateJavaObject(JavaObject obj) {
        List<JavaObjectArg> args = obj.get_args_list();
        Class[] paraTypes = new Class[args.size()];
        Object[] paraValues = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            JavaObjectArg arg = args.get(i);
            paraValues[i] = arg.getFieldValue();
            paraTypes[i] = ((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.INT_ARG) ? Integer.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.LONG_ARG) ? Long.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.STRING_ARG) ? String.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.BOOL_ARG) ? Boolean.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.BINARY_ARG) ? ByteBuffer.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.DOUBLE_ARG) ? Double.class : Object.class)))));
        }
        try {
            Class<?> clazz = Class.forName(obj.get_full_class_name());
            Constructor<?> cons = clazz.getConstructor(paraTypes);
            return cons.newInstance(paraValues);
        }
        catch (Exception e) {
            LOG.error("java object instantiation failed", (Throwable)e);
            return null;
        }
    }

    public static Grouping._Fields groupingType(Grouping grouping) {
        return (Grouping._Fields)grouping.getSetField();
    }

    public static List<String> fieldGrouping(Grouping grouping) {
        if (!Grouping._Fields.FIELDS.equals((Object)Thrift.groupingType(grouping))) {
            throw new IllegalArgumentException("Tried to get grouping fields from non fields grouping");
        }
        return grouping.get_fields();
    }

    public static boolean isGlobalGrouping(Grouping grouping) {
        if (Grouping._Fields.FIELDS.equals((Object)Thrift.groupingType(grouping))) {
            return Thrift.fieldGrouping(grouping).isEmpty();
        }
        return false;
    }

    public static int getParallelismHint(ComponentCommon componentCommon) {
        if (!componentCommon.is_set_parallelism_hint()) {
            return 1;
        }
        return componentCommon.get_parallelism_hint();
    }

    public static ComponentObject serializeComponentObject(Object obj) {
        return ComponentObject.serialized_java(Utils.javaSerialize(obj));
    }

    public static Object deserializeComponentObject(ComponentObject obj) {
        if (obj.getSetField() != ComponentObject._Fields.SERIALIZED_JAVA) {
            throw new RuntimeException("Cannot deserialize non-java-serialized object");
        }
        return Utils.javaDeserialize(obj.get_serialized_java(), Serializable.class);
    }

    public static ComponentCommon prepareComponentCommon(Map<GlobalStreamId, Grouping> inputs, Map<String, StreamInfo> outputs, Integer parallelismHint) {
        return Thrift.prepareComponentCommon(inputs, outputs, parallelismHint, null);
    }

    public static ComponentCommon prepareComponentCommon(Map<GlobalStreamId, Grouping> inputs, Map<String, StreamInfo> outputs, Integer parallelismHint, Map<String, Object> conf) {
        HashMap<GlobalStreamId, Grouping> mappedInputs = new HashMap<GlobalStreamId, Grouping>();
        HashMap<String, StreamInfo> mappedOutputs = new HashMap<String, StreamInfo>();
        if (inputs != null && !inputs.isEmpty()) {
            mappedInputs.putAll(inputs);
        }
        if (outputs != null && !outputs.isEmpty()) {
            mappedOutputs.putAll(outputs);
        }
        ComponentCommon component = new ComponentCommon(mappedInputs, mappedOutputs);
        if (parallelismHint != null) {
            component.set_parallelism_hint(parallelismHint);
        }
        if (conf != null) {
            component.set_json_conf(JSONValue.toJSONString(conf));
        }
        return component;
    }

    public static SpoutSpec prepareSerializedSpoutDetails(IRichSpout spout, Map<String, StreamInfo> outputs) {
        return new SpoutSpec(ComponentObject.serialized_java(Utils.javaSerialize(spout)), Thrift.prepareComponentCommon(new HashMap<GlobalStreamId, Grouping>(), outputs, null, null));
    }

    public static Bolt prepareSerializedBoltDetails(Map<GlobalStreamId, Grouping> inputs, IBolt bolt, Map<String, StreamInfo> outputs, Integer parallelismHint, Map<String, Object> conf) {
        ComponentCommon common = Thrift.prepareComponentCommon(inputs, outputs, parallelismHint, conf);
        return new Bolt(ComponentObject.serialized_java(Utils.javaSerialize(bolt)), common);
    }

    public static BoltDetails prepareBoltDetails(Map<GlobalStreamId, Grouping> inputs, Object bolt) {
        return Thrift.prepareBoltDetails(inputs, bolt, null, null);
    }

    public static BoltDetails prepareBoltDetails(Map<GlobalStreamId, Grouping> inputs, Object bolt, Integer parallelismHint) {
        return Thrift.prepareBoltDetails(inputs, bolt, parallelismHint, null);
    }

    public static BoltDetails prepareBoltDetails(Map<GlobalStreamId, Grouping> inputs, Object bolt, Integer parallelismHint, Map<String, Object> conf) {
        BoltDetails details = new BoltDetails(bolt, conf, parallelismHint, inputs);
        return details;
    }

    public static SpoutDetails prepareSpoutDetails(IRichSpout spout) {
        return Thrift.prepareSpoutDetails(spout, null, null);
    }

    public static SpoutDetails prepareSpoutDetails(IRichSpout spout, Integer parallelismHint) {
        return Thrift.prepareSpoutDetails(spout, parallelismHint, null);
    }

    public static SpoutDetails prepareSpoutDetails(IRichSpout spout, Integer parallelismHint, Map<String, Object> conf) {
        SpoutDetails details = new SpoutDetails(spout, parallelismHint, conf);
        return details;
    }

    private static void addInputs(BoltDeclarer declarer, Map<GlobalStreamId, Grouping> inputs) {
        for (Map.Entry<GlobalStreamId, Grouping> entry : inputs.entrySet()) {
            declarer.grouping(entry.getKey(), entry.getValue());
        }
    }

    public static StormTopology buildTopology(HashMap<String, SpoutDetails> spoutMap, HashMap<String, BoltDetails> boltMap, HashMap<String, StateSpoutSpec> stateMap) {
        return Thrift.buildTopology(spoutMap, boltMap);
    }

    public static StormTopology buildTopology(Map<String, SpoutDetails> spoutMap, Map<String, BoltDetails> boltMap) {
        Object spec;
        String spoutId;
        TopologyBuilder builder = new TopologyBuilder();
        for (Map.Entry<String, SpoutDetails> entry : spoutMap.entrySet()) {
            spoutId = entry.getKey();
            spec = entry.getValue();
            SpoutDeclarer spoutDeclarer = builder.setSpout(spoutId, ((SpoutDetails)spec).getSpout(), (Number)((SpoutDetails)spec).getParallelism());
            spoutDeclarer.addConfigurations(((SpoutDetails)spec).getConf());
        }
        for (Map.Entry<String, Object> entry : boltMap.entrySet()) {
            spoutId = entry.getKey();
            spec = (BoltDetails)entry.getValue();
            BoltDeclarer boltDeclarer = null;
            boltDeclarer = ((BoltDetails)spec).bolt instanceof IRichBolt ? builder.setBolt(spoutId, (IRichBolt)((BoltDetails)spec).getBolt(), (Number)((BoltDetails)spec).getParallelism()) : builder.setBolt(spoutId, (IBasicBolt)((BoltDetails)spec).getBolt(), (Number)((BoltDetails)spec).getParallelism());
            boltDeclarer.addConfigurations(((BoltDetails)spec).getConf());
            Thrift.addInputs(boltDeclarer, ((BoltDetails)spec).getInputs());
        }
        return builder.createTopology();
    }

    static {
        Set<StormTopology._Fields> keys = StormTopology.metaDataMap.keySet();
        STORM_TOPOLOGY_FIELDS = new StormTopology._Fields[keys.size()];
        keys.toArray(STORM_TOPOLOGY_FIELDS);
    }

    public static class BoltDetails {
        private Object bolt;
        private Map<String, Object> conf;
        private Integer parallelism;
        private Map<GlobalStreamId, Grouping> inputs;

        public BoltDetails(Object bolt, Map<String, Object> conf, Integer parallelism, Map<GlobalStreamId, Grouping> inputs) {
            this.bolt = bolt;
            this.conf = conf;
            this.parallelism = parallelism;
            this.inputs = inputs;
        }

        public Object getBolt() {
            return this.bolt;
        }

        public Map<String, Object> getConf() {
            return this.conf;
        }

        public Map<GlobalStreamId, Grouping> getInputs() {
            return this.inputs;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }
    }

    public static class SpoutDetails {
        private IRichSpout spout;
        private Integer parallelism;
        private Map<String, Object> conf;

        public SpoutDetails(IRichSpout spout, Integer parallelism, Map<String, Object> conf) {
            this.spout = spout;
            this.parallelism = parallelism;
            this.conf = conf;
        }

        public IRichSpout getSpout() {
            return this.spout;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }

        public Map<String, Object> getConf() {
            return this.conf;
        }
    }
}

