/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;

public class MysqlHandler
extends SqlDialect.BaseHandler {
    public static final MysqlHandler INSTANCE = new MysqlHandler();

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                this.unparseFloor(writer, call);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private void unparseFloor(SqlWriter writer, SqlCall call) {
        String format;
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = (TimeUnitRange)node.getValue();
        if (unit == TimeUnitRange.WEEK) {
            writer.print("STR_TO_DATE");
            SqlWriter.Frame frame = writer.startList("(", ")");
            writer.print("DATE_FORMAT(");
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            writer.print(", '%x%v-1'), '%x%v-%w'");
            writer.endList(frame);
            return;
        }
        switch (unit) {
            case YEAR: {
                format = "%Y-01-01";
                break;
            }
            case MONTH: {
                format = "%Y-%m-01";
                break;
            }
            case DAY: {
                format = "%Y-%m-%d";
                break;
            }
            case HOUR: {
                format = "%Y-%m-%d %k:00:00";
                break;
            }
            case MINUTE: {
                format = "%Y-%m-%d %k:%i:00";
                break;
            }
            case SECOND: {
                format = "%Y-%m-%d %k:%i:%s";
                break;
            }
            default: {
                throw new AssertionError((Object)("MYSQL does not support FLOOR for time unit: " + unit));
            }
        }
        writer.print("DATE_FORMAT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep(",", true);
        writer.print("'" + format + "'");
        writer.endList(frame);
    }
}

