/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.codec.http;

import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.storm.shade.org.jboss.netty.buffer.CompositeChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.storm.shade.org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpCodecUtil;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.apache.storm.shade.org.jboss.netty.handler.codec.http.HttpMessage;
import org.apache.storm.shade.org.jboss.netty.util.CharsetUtil;

public class HttpChunkAggregator
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final ChannelBuffer CONTINUE = ChannelBuffers.copiedBuffer("HTTP/1.1 100 Continue\r\n\r\n", CharsetUtil.US_ASCII);
    private final int maxContentLength;
    private HttpMessage currentMessage;
    private boolean tooLongFrameFound;
    private ChannelHandlerContext ctx;
    private int maxCumulationBufferComponents = 1024;

    public HttpChunkAggregator(int maxContentLength) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        HttpMessage currentMessage = this.currentMessage;
        if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            this.tooLongFrameFound = false;
            if (HttpHeaders.is100ContinueExpected(m)) {
                Channels.write(ctx, Channels.succeededFuture(ctx.getChannel()), CONTINUE.duplicate());
            }
            if (m.isChunked()) {
                HttpCodecUtil.removeTransferEncodingChunked(m);
                m.setChunked(false);
                this.currentMessage = m;
            } else {
                this.currentMessage = null;
                ctx.sendUpstream(e);
            }
        } else if (msg instanceof HttpChunk) {
            if (currentMessage == null) {
                throw new IllegalStateException("received " + HttpChunk.class.getSimpleName() + " without " + HttpMessage.class.getSimpleName());
            }
            HttpChunk chunk = (HttpChunk)msg;
            if (this.tooLongFrameFound) {
                if (chunk.isLast()) {
                    this.currentMessage = null;
                }
                return;
            }
            ChannelBuffer content = currentMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - chunk.getContent().readableBytes()) {
                this.tooLongFrameFound = true;
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            this.appendToCumulation(chunk.getContent());
            if (chunk.isLast()) {
                this.currentMessage = null;
                if (chunk instanceof HttpChunkTrailer) {
                    HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                    for (Map.Entry header : trailer.trailingHeaders()) {
                        currentMessage.headers().set((String)header.getKey(), header.getValue());
                    }
                }
                currentMessage.headers().set("Content-Length", String.valueOf(content.readableBytes()));
                Channels.fireMessageReceived(ctx, (Object)currentMessage, e.getRemoteAddress());
            }
        } else {
            ctx.sendUpstream(e);
        }
    }

    protected void appendToCumulation(ChannelBuffer input) {
        ChannelBuffer cumulation = this.currentMessage.getContent();
        if (cumulation instanceof CompositeChannelBuffer) {
            CompositeChannelBuffer composite = (CompositeChannelBuffer)cumulation;
            if (composite.numComponents() >= this.maxCumulationBufferComponents) {
                this.currentMessage.setContent(ChannelBuffers.wrappedBuffer(composite.copy(), input));
            } else {
                List<ChannelBuffer> decomposed = composite.decompose(0, composite.readableBytes());
                ChannelBuffer[] buffers = decomposed.toArray(new ChannelBuffer[decomposed.size() + 1]);
                buffers[buffers.length - 1] = input;
                this.currentMessage.setContent(ChannelBuffers.wrappedBuffer(buffers));
            }
        } else {
            this.currentMessage.setContent(ChannelBuffers.wrappedBuffer(cumulation, input));
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

