/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.api.transaction;

import org.apache.storm.shade.com.google.common.base.Predicate;
import org.apache.storm.shade.org.apache.curator.framework.api.transaction.OperationType;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;

public class CuratorTransactionResult {
    private final OperationType type;
    private final String forPath;
    private final String resultPath;
    private final Stat resultStat;
    private final int error;

    public static Predicate<CuratorTransactionResult> ofTypeAndPath(final OperationType type, final String forPath) {
        return new Predicate<CuratorTransactionResult>(){

            @Override
            public boolean apply(CuratorTransactionResult result) {
                return result.getType() == type && result.getForPath().equals(forPath);
            }
        };
    }

    public CuratorTransactionResult(OperationType type, String forPath, String resultPath, Stat resultStat) {
        this(type, forPath, resultPath, resultStat, 0);
    }

    public CuratorTransactionResult(OperationType type, String forPath, String resultPath, Stat resultStat, int error) {
        this.forPath = forPath;
        this.resultPath = resultPath;
        this.resultStat = resultStat;
        this.type = type;
        this.error = error;
    }

    public OperationType getType() {
        return this.type;
    }

    public String getForPath() {
        return this.forPath;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public Stat getResultStat() {
        return this.resultStat;
    }

    public int getError() {
        return this.error;
    }
}

