/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class RMAppsBlock
extends AppsBlock {
    private ResourceManager rm;

    @Inject
    RMAppsBlock(ResourceManager rm, ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(appBaseProt, ctx);
        this.rm = rm;
    }

    protected void renderData(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".priority", "Application Priority").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".runningcontainer", "Running Containers").th(".allocatedCpu", "Allocated CPU VCores").th(".allocatedMemory", "Allocated Memory MB").th(".queuePercentage", "% of Queue").th(".clusterPercentage", "% of Cluster").th(".progress", "Progress").th(".ui", "Tracking UI").th(".blacklisted", "Blacklisted Nodes")._())._()).tbody();
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (ApplicationReport appReport : this.appReports) {
            String trackingURL;
            if (!this.reqAppStates.isEmpty() && !this.reqAppStates.contains(appReport.getYarnApplicationState())) continue;
            AppInfo app = new AppInfo(appReport);
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.fromString((String)app.getCurrentAppAttemptId());
            String queuePercent = "N/A";
            String clusterPercent = "N/A";
            if (appReport.getApplicationResourceUsageReport() != null) {
                queuePercent = String.format("%.1f", Float.valueOf(appReport.getApplicationResourceUsageReport().getQueueUsagePercentage()));
                clusterPercent = String.format("%.1f", Float.valueOf(appReport.getApplicationResourceUsageReport().getClusterUsagePercentage()));
            }
            String blacklistedNodesCount = "N/A";
            RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appAttemptId.getApplicationId());
            if (rmApp != null) {
                Set<String> nodes;
                RMAppAttempt appAttempt = rmApp.getRMAppAttempt(appAttemptId);
                Set<String> set = nodes = null == appAttempt ? null : appAttempt.getBlacklistedNodes();
                if (nodes != null) {
                    blacklistedNodesCount = String.valueOf(nodes.size());
                }
            }
            String percent = StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(app.getProgress())});
            appsTableData.append("[\"<a href='").append(this.url(new String[]{"app", app.getAppId()})).append("'>").append(app.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getUser()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getType()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getQueue()))).append("\",\"").append(String.valueOf(app.getPriority())).append("\",\"").append(app.getStartedTime()).append("\",\"").append(app.getFinishedTime()).append("\",\"").append((Object)(app.getAppState() == null ? "N/A" : app.getAppState())).append("\",\"").append(app.getFinalAppStatus()).append("\",\"").append(app.getRunningContainers() == -1 ? "N/A" : String.valueOf(app.getRunningContainers())).append("\",\"").append(app.getAllocatedCpuVcores() == -1L ? "N/A" : String.valueOf(app.getAllocatedCpuVcores())).append("\",\"").append(app.getAllocatedMemoryMB() == -1L ? "N/A" : String.valueOf(app.getAllocatedMemoryMB())).append("\",\"").append(queuePercent).append("\",\"").append(clusterPercent).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a ");
            String string = trackingURL = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") || app.getAppState() == YarnApplicationState.NEW ? null : app.getTrackingUrl();
            String trackingUI = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") || app.getAppState() == YarnApplicationState.NEW ? "Unassigned" : (app.getAppState() == YarnApplicationState.FINISHED || app.getAppState() == YarnApplicationState.FAILED || app.getAppState() == YarnApplicationState.KILLED ? "History" : "ApplicationMaster");
            appsTableData.append(trackingURL == null ? "#" : "href='" + trackingURL).append("'>").append(trackingUI).append("</a>\",").append("\"").append(blacklistedNodesCount).append("\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var appsTableData=" + appsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

