/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AssignmentInformation {
    private final int[] operationCounts;
    private final Resource[] operationResources;
    private final List<AssignmentDetails>[] operationDetails;

    public AssignmentInformation() {
        int numOps = Operation.size();
        this.operationCounts = new int[numOps];
        this.operationResources = new Resource[numOps];
        this.operationDetails = new List[numOps];
        for (int i = 0; i < numOps; ++i) {
            this.operationCounts[i] = 0;
            this.operationResources[i] = Resource.newInstance((int)0, (int)0);
            this.operationDetails[i] = new ArrayList<AssignmentDetails>();
        }
    }

    public int getNumAllocations() {
        return this.operationCounts[Operation.ALLOCATION.ordinal()];
    }

    public void incrAllocations() {
        this.increment(Operation.ALLOCATION, 1);
    }

    public void incrAllocations(int by) {
        this.increment(Operation.ALLOCATION, by);
    }

    public int getNumReservations() {
        return this.operationCounts[Operation.RESERVATION.ordinal()];
    }

    public void incrReservations() {
        this.increment(Operation.RESERVATION, 1);
    }

    public void incrReservations(int by) {
        this.increment(Operation.RESERVATION, by);
    }

    private void increment(Operation op, int by) {
        int n = op.ordinal();
        this.operationCounts[n] = this.operationCounts[n] + by;
    }

    public Resource getAllocated() {
        return this.operationResources[Operation.ALLOCATION.ordinal()];
    }

    public Resource getReserved() {
        return this.operationResources[Operation.RESERVATION.ordinal()];
    }

    private void addAssignmentDetails(Operation op, ContainerId containerId, String queue) {
        this.getDetails(op).add(new AssignmentDetails(containerId, queue));
    }

    public void addAllocationDetails(ContainerId containerId, String queue) {
        this.addAssignmentDetails(Operation.ALLOCATION, containerId, queue);
    }

    public void addReservationDetails(ContainerId containerId, String queue) {
        this.addAssignmentDetails(Operation.RESERVATION, containerId, queue);
    }

    private List<AssignmentDetails> getDetails(Operation op) {
        return this.operationDetails[op.ordinal()];
    }

    public List<AssignmentDetails> getAllocationDetails() {
        return this.getDetails(Operation.ALLOCATION);
    }

    public List<AssignmentDetails> getReservationDetails() {
        return this.getDetails(Operation.RESERVATION);
    }

    private ContainerId getFirstContainerIdFromOperation(Operation op) {
        List<AssignmentDetails> assignDetails = this.getDetails(op);
        if (assignDetails != null && !assignDetails.isEmpty()) {
            return assignDetails.get((int)0).containerId;
        }
        return null;
    }

    public ContainerId getFirstAllocatedOrReservedContainerId() {
        ContainerId containerId = this.getFirstContainerIdFromOperation(Operation.ALLOCATION);
        if (null != containerId) {
            return containerId;
        }
        return this.getFirstContainerIdFromOperation(Operation.RESERVATION);
    }

    public static class AssignmentDetails {
        public ContainerId containerId;
        public String queue;

        public AssignmentDetails(ContainerId containerId, String queue) {
            this.containerId = containerId;
            this.queue = queue;
        }
    }

    public static enum Operation {
        ALLOCATION,
        RESERVATION;

        private static int SIZE;

        static int size() {
            return SIZE;
        }

        static {
            SIZE = Operation.values().length;
        }
    }
}

