/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.IterativePlanner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocatorGreedyRLE;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageEarliestStartByJobArrival;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyReservationAgent
implements ReservationAgent {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyReservationAgent.class);
    private final ReservationAgent planner;
    public static final String GREEDY_FAVOR_EARLY_ALLOCATION = "yarn.resourcemanager.reservation-system.favor-early-allocation";
    public static final boolean DEFAULT_GREEDY_FAVOR_EARLY_ALLOCATION = true;
    private final boolean allocateLeft;

    public GreedyReservationAgent() {
        this(new Configuration());
    }

    public GreedyReservationAgent(Configuration yarnConfiguration) {
        this.allocateLeft = yarnConfiguration.getBoolean(GREEDY_FAVOR_EARLY_ALLOCATION, true);
        if (this.allocateLeft) {
            LOG.info("Initializing the GreedyReservationAgent to favor \"early\" (left) allocations (controlled by parameter: yarn.resourcemanager.reservation-system.favor-early-allocation)");
        } else {
            LOG.info("Initializing the GreedyReservationAgent to favor \"late\" (right) allocations (controlled by parameter: yarn.resourcemanager.reservation-system.favor-early-allocation)");
        }
        this.planner = new IterativePlanner(new StageEarliestStartByJobArrival(), new StageAllocatorGreedyRLE(this.allocateLeft), this.allocateLeft);
    }

    public boolean isAllocateLeft() {
        return this.allocateLeft;
    }

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("placing the following ReservationRequest: " + contract);
        try {
            boolean res = this.planner.createReservation(reservationId, user, plan, contract);
            if (res) {
                LOG.info("OUTCOME: SUCCESS, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            } else {
                LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            }
            return res;
        }
        catch (PlanningException e) {
            LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            throw e;
        }
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("updating the following ReservationRequest: " + contract);
        return this.planner.updateReservation(reservationId, user, plan, contract);
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        LOG.info("removing the following ReservationId: " + reservationId);
        return this.planner.deleteReservation(reservationId, user, plan);
    }
}

