/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.MismatchedUserException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class NoOverCommitPolicy
implements SharingPolicy {
    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        ReservationAllocation oldReservation = plan.getReservationById(reservation.getReservationId());
        if (oldReservation != null && !oldReservation.getUser().equals(reservation.getUser())) {
            throw new MismatchedUserException("Updating an existing reservation with mismatching user:" + oldReservation.getUser() + " != " + reservation.getUser());
        }
        RLESparseResourceAllocation available = plan.getAvailableResourceOverTime(reservation.getUser(), reservation.getReservationId(), reservation.getStartTime(), reservation.getEndTime());
        try {
            RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), available, reservation.getResourcesOverTime(), RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, reservation.getStartTime(), reservation.getEndTime());
        }
        catch (PlanningException p) {
            throw new ResourceOverCommitException("Resources at time  would be overcommitted by accepting reservation: " + reservation.getReservationId());
        }
    }

    @Override
    public long getValidWindow() {
        return 0L;
    }

    @Override
    public void init(String planQueuePath, ReservationSchedulerConfiguration conf) {
    }

    @Override
    public RLESparseResourceAllocation availableResources(RLESparseResourceAllocation available, Plan plan, String user, ReservationId oldId, long start, long end) throws PlanningException {
        return available;
    }
}

