/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEventType;

public class AppAttemptFinishedEvent
extends SystemMetricsEvent {
    private ApplicationAttemptId appAttemptId;
    private String trackingUrl;
    private String originalTrackingUrl;
    private String diagnosticsInfo;
    private FinalApplicationStatus appStatus;
    private YarnApplicationAttemptState state;
    private ContainerId masterContainerId;

    public AppAttemptFinishedEvent(ApplicationAttemptId appAttemptId, String trackingUrl, String originalTrackingUrl, String diagnosticsInfo, FinalApplicationStatus appStatus, YarnApplicationAttemptState state, long finishedTime, ContainerId masterContainerId) {
        super(SystemMetricsEventType.APP_ATTEMPT_FINISHED, finishedTime);
        this.appAttemptId = appAttemptId;
        this.trackingUrl = trackingUrl;
        this.originalTrackingUrl = originalTrackingUrl;
        this.diagnosticsInfo = diagnosticsInfo;
        this.appStatus = appStatus;
        this.state = state;
        this.masterContainerId = masterContainerId;
    }

    public int hashCode() {
        return this.appAttemptId.getApplicationId().hashCode();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getOriginalTrackingURL() {
        return this.originalTrackingUrl;
    }

    public String getDiagnosticsInfo() {
        return this.diagnosticsInfo;
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        return this.appStatus;
    }

    public YarnApplicationAttemptState getYarnApplicationAttemptState() {
        return this.state;
    }

    public ContainerId getMasterContainerId() {
        return this.masterContainerId;
    }
}

