/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import org.apache.storm.shade.org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperServerCnxnFactory.class);
    int _port;
    NIOServerCnxnFactory _factory;

    public ZookeeperServerCnxnFactory(int port, int maxClientCnxns) {
        int max;
        if (port <= 0) {
            this._port = 2000;
            max = 65535;
        } else {
            this._port = port;
            max = port;
        }
        try {
            this._factory = new NIOServerCnxnFactory();
        }
        catch (IOException e) {
            this._port = 0;
            this._factory = null;
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        while (this._port <= max) {
            try {
                this._factory.configure(new InetSocketAddress(this._port), maxClientCnxns);
                LOG.debug("Zookeeper server successfully binded at port " + this._port);
                break;
            }
            catch (BindException e) {
            }
            catch (IOException e2) {
                this._port = 0;
                this._factory = null;
                e2.printStackTrace();
                throw new RuntimeException(e2.getMessage());
            }
            ++this._port;
        }
        if (this._port > max) {
            this._port = 0;
            this._factory = null;
            LOG.error("Failed to find a port for Zookeeper");
            throw new RuntimeException("No port is available to launch an inprocess zookeeper.");
        }
    }

    public int port() {
        return this._port;
    }

    public NIOServerCnxnFactory factory() {
        return this._factory;
    }
}

