/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.Utils;

public class ServerConfigUtils {
    public static final String FILE_SEPARATOR = File.separator;
    public static final String NIMBUS_DO_NOT_REASSIGN = "NIMBUS-DO-NOT-REASSIGN";
    public static final String RESOURCES_SUBDIR = "resources";
    private static ServerConfigUtils _instance = new ServerConfigUtils();

    public static ServerConfigUtils setInstance(ServerConfigUtils u) {
        ServerConfigUtils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    public static String masterLocalDir(Map<String, Object> conf) throws IOException {
        String ret = ConfigUtils.absoluteStormLocalDir(conf) + FILE_SEPARATOR + "nimbus";
        FileUtils.forceMkdir((File)new File(ret));
        return ret;
    }

    public static String masterInimbusDir(Map<String, Object> conf) throws IOException {
        return ServerConfigUtils.masterLocalDir(conf) + FILE_SEPARATOR + "inimbus";
    }

    public static LocalState nimbusTopoHistoryState(Map<String, Object> conf) throws IOException {
        return _instance.nimbusTopoHistoryStateImpl(conf);
    }

    public static String masterInbox(Map<String, Object> conf) throws IOException {
        String ret = ServerConfigUtils.masterLocalDir(conf) + FILE_SEPARATOR + "inbox";
        FileUtils.forceMkdir((File)new File(ret));
        return ret;
    }

    public static String masterStormDistRoot(Map<String, Object> conf) throws IOException {
        String ret = ConfigUtils.stormDistPath((String)ServerConfigUtils.masterLocalDir(conf));
        FileUtils.forceMkdir((File)new File(ret));
        return ret;
    }

    public static List<String> getTopoLogsUsers(Map<String, Object> topologyConf) {
        List logsUsers = (List)topologyConf.get("logs.users");
        List topologyUsers = (List)topologyConf.get("topology.users");
        HashSet<String> mergedUsers = new HashSet<String>();
        if (logsUsers != null) {
            for (String user : logsUsers) {
                if (user == null) continue;
                mergedUsers.add(user);
            }
        }
        if (topologyUsers != null) {
            for (String user : topologyUsers) {
                if (user == null) continue;
                mergedUsers.add(user);
            }
        }
        ArrayList<String> ret = new ArrayList<String>(mergedUsers);
        Collections.sort(ret);
        return ret;
    }

    public static List<String> getTopoLogsGroups(Map<String, Object> topologyConf) {
        List logsGroups = (List)topologyConf.get("logs.groups");
        List topologyGroups = (List)topologyConf.get("topology.groups");
        HashSet<String> mergedGroups = new HashSet<String>();
        if (logsGroups != null) {
            for (String group : logsGroups) {
                if (group == null) continue;
                mergedGroups.add(group);
            }
        }
        if (topologyGroups != null) {
            for (String group : topologyGroups) {
                if (group == null) continue;
                mergedGroups.add(group);
            }
        }
        ArrayList<String> ret = new ArrayList<String>(mergedGroups);
        Collections.sort(ret);
        return ret;
    }

    public static String masterStormDistRoot(Map<String, Object> conf, String stormId) throws IOException {
        return ServerConfigUtils.masterStormDistRoot(conf) + FILE_SEPARATOR + stormId;
    }

    public static String supervisorTmpDir(Map<String, Object> conf) throws IOException {
        String ret = ConfigUtils.supervisorLocalDir(conf) + FILE_SEPARATOR + "tmp";
        FileUtils.forceMkdir((File)new File(ret));
        return ret;
    }

    public static String supervisorIsupervisorDir(Map<String, Object> conf) throws IOException {
        return ConfigUtils.supervisorLocalDir(conf) + FILE_SEPARATOR + "isupervisor";
    }

    public static LocalState supervisorState(Map<String, Object> conf) throws IOException {
        return _instance.supervisorStateImpl(conf);
    }

    public static String absoluteHealthCheckDir(Map<String, Object> conf) {
        String stormHome = System.getProperty("storm.home");
        String healthCheckDir = (String)conf.get("storm.health.check.dir");
        if (healthCheckDir == null) {
            return stormHome + FILE_SEPARATOR + "healthchecks";
        }
        if (new File(healthCheckDir).isAbsolute()) {
            return healthCheckDir;
        }
        return stormHome + FILE_SEPARATOR + healthCheckDir;
    }

    public static File getLogMetaDataFile(String fname) {
        String[] subStrings = fname.split(Pattern.quote(FILE_SEPARATOR));
        String id = subStrings[0];
        Integer port = Integer.parseInt(subStrings[1]);
        return ServerConfigUtils.getLogMetaDataFile(Utils.readStormConfig(), id, port);
    }

    public static File getLogMetaDataFile(Map<String, Object> conf, String id, Integer port) {
        String fname = ConfigUtils.workerArtifactsRoot(conf, (String)id, (Integer)port) + FILE_SEPARATOR + "worker.yaml";
        return new File(fname);
    }

    public static String masterStormJarPath(String stormRoot) {
        return stormRoot + FILE_SEPARATOR + "stormjar.jar";
    }

    public LocalState supervisorStateImpl(Map<String, Object> conf) throws IOException {
        return new LocalState(ConfigUtils.supervisorLocalDir(conf) + FILE_SEPARATOR + "localstate", true);
    }

    public LocalState nimbusTopoHistoryStateImpl(Map<String, Object> conf) throws IOException {
        return new LocalState(ServerConfigUtils.masterLocalDir(conf) + FILE_SEPARATOR + "history", true);
    }
}

