/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.Component;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceAwareStrategy
extends BaseResourceAwareStrategy
implements IStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceAwareStrategy.class);

    @Override
    public SchedulingResult schedule(Cluster cluster, TopologyDetails td) {
        SchedulingResult result;
        this.prepare(cluster);
        if (this.nodes.getNodes().size() <= 0) {
            LOG.warn("No available nodes to schedule tasks on!");
            return SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, "No available nodes to schedule tasks on!");
        }
        HashSet<ExecutorDetails> unassignedExecutors = new HashSet<ExecutorDetails>(this.cluster.getUnassignedExecutors(td));
        LOG.debug("{} ExecutorsNeedScheduling: {}", (Object)td.getId(), unassignedExecutors);
        ArrayList<ExecutorDetails> scheduledTasks = new ArrayList<ExecutorDetails>();
        List<Component> spouts = this.getSpouts(td);
        if (spouts.size() == 0) {
            LOG.error("Cannot find a Spout!");
            return SchedulingResult.failure(SchedulingStatus.FAIL_INVALID_TOPOLOGY, "Cannot find a Spout!");
        }
        List<ExecutorDetails> orderedExecutors = this.orderExecutors(td, unassignedExecutors);
        HashSet<ExecutorDetails> executorsNotScheduled = new HashSet<ExecutorDetails>(unassignedExecutors);
        List<String> favoredNodesIds = this.makeHostToNodeIds((List)td.getConf().get("topology.scheduler.favored.nodes"));
        List<String> unFavoredNodesIds = this.makeHostToNodeIds((List)td.getConf().get("topology.scheduler.unfavored.nodes"));
        Iterable<String> sortedNodes = this.sortAllNodes(td, null, favoredNodesIds, unFavoredNodesIds);
        for (ExecutorDetails exec : orderedExecutors) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            LOG.debug("Attempting to schedule: {} of component {}[ REQ {} ]", new Object[]{exec, td.getExecutorToComponent().get(exec), td.getTaskResourceReqList(exec)});
            if (this.scheduleExecutor(exec, td, scheduledTasks, sortedNodes)) continue;
            return this.mkNotEnoughResources(td);
        }
        executorsNotScheduled.removeAll(scheduledTasks);
        LOG.debug("/* Scheduling left over task (most likely sys tasks) */");
        for (ExecutorDetails exec : executorsNotScheduled) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (this.scheduleExecutor(exec, td, scheduledTasks, sortedNodes)) continue;
            return this.mkNotEnoughResources(td);
        }
        executorsNotScheduled.removeAll(scheduledTasks);
        if (executorsNotScheduled.size() > 0) {
            LOG.error("Not all executors successfully scheduled: {}", executorsNotScheduled);
            result = SchedulingResult.failure(SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES, td.getExecutors().size() - unassignedExecutors.size() + "/" + td.getExecutors().size() + " executors scheduled");
        } else {
            LOG.debug("All resources successfully scheduled!");
            result = SchedulingResult.success("Fully Scheduled by " + this.getClass().getSimpleName());
        }
        return result;
    }

    @Override
    protected TreeSet<BaseResourceAwareStrategy.ObjectResources> sortObjectResources(BaseResourceAwareStrategy.AllResources allResources, ExecutorDetails exec, TopologyDetails topologyDetails, BaseResourceAwareStrategy.ExistingScheduleFunc existingScheduleFunc) {
        for (BaseResourceAwareStrategy.ObjectResources objectResources : allResources.objectResources) {
            objectResources.effectiveResources = allResources.availableResourcesOverall.calculateMinPercentageUsedBy(objectResources.availableResources);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Effective resources for {} is {}, and numExistingSchedule is {}", new Object[]{objectResources.id, objectResources.effectiveResources, existingScheduleFunc.getNumExistingSchedule(objectResources.id)});
        }
        TreeSet<BaseResourceAwareStrategy.ObjectResources> sortedObjectResources = new TreeSet<BaseResourceAwareStrategy.ObjectResources>((o1, o2) -> {
            double o2Avg;
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            if (o1.effectiveResources > o2.effectiveResources) {
                return -1;
            }
            if (o1.effectiveResources < o2.effectiveResources) {
                return 1;
            }
            double o1Avg = allResources.availableResourcesOverall.calculateAveragePercentageUsedBy(o1.availableResources);
            if (o1Avg > (o2Avg = allResources.availableResourcesOverall.calculateAveragePercentageUsedBy(o2.availableResources))) {
                return -1;
            }
            if (o1Avg < o2Avg) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        });
        sortedObjectResources.addAll(allResources.objectResources);
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }
}

