/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.multitenant.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodePool {
    private static final Logger LOG = LoggerFactory.getLogger(NodePool.class);
    protected Cluster _cluster;
    protected Map<String, Node> _nodeIdToNode;

    public static int slotsAvailable(NodePool[] pools) {
        int slotsAvailable = 0;
        for (NodePool pool : pools) {
            slotsAvailable += pool.slotsAvailable();
        }
        return slotsAvailable;
    }

    public static int nodesAvailable(NodePool[] pools) {
        int nodesAvailable = 0;
        for (NodePool pool : pools) {
            nodesAvailable += pool.nodesAvailable();
        }
        return nodesAvailable;
    }

    public static Collection<Node> takeNodesBySlot(int slotsNeeded, NodePool[] pools) {
        LOG.debug("Trying to grab {} free slots from {}", (Object)slotsNeeded, (Object)pools);
        HashSet<Node> ret = new HashSet<Node>();
        for (NodePool pool : pools) {
            Collection<Node> got = pool.takeNodesBySlots(slotsNeeded);
            ret.addAll(got);
            LOG.debug("Got {} nodes so far need {} more slots", (Object)ret.size(), (Object)(slotsNeeded -= Node.countFreeSlotsAlive(got)));
            if (slotsNeeded <= 0) break;
        }
        return ret;
    }

    public static Collection<Node> takeNodes(int nodesNeeded, NodePool[] pools) {
        LOG.debug("Trying to grab {} free nodes from {}", (Object)nodesNeeded, (Object)pools);
        HashSet<Node> ret = new HashSet<Node>();
        for (NodePool pool : pools) {
            Collection<Node> got = pool.takeNodes(nodesNeeded);
            ret.addAll(got);
            LOG.debug("Got {} nodes so far need {} more nodes", (Object)ret.size(), (Object)(nodesNeeded -= got.size()));
            if (nodesNeeded <= 0) break;
        }
        return ret;
    }

    public static int getNodeCountIfSlotsWereTaken(int slots, NodePool[] pools) {
        LOG.debug("How many nodes to get {} slots from {}", (Object)slots, (Object)pools);
        int total = 0;
        for (NodePool pool : pools) {
            NodeAndSlotCounts ns = pool.getNodeAndSlotCountIfSlotsWereTaken(slots);
            LOG.debug("Found {} nodes so far {} more slots needed", (Object)(total += ns._nodes), (Object)(slots -= ns._slots));
            if (slots <= 0) break;
        }
        return total;
    }

    public void init(Cluster cluster, Map<String, Node> nodeIdToNode) {
        this._cluster = cluster;
        this._nodeIdToNode = nodeIdToNode;
    }

    public abstract void addTopology(TopologyDetails var1);

    public abstract boolean canAdd(TopologyDetails var1);

    public abstract int slotsAvailable();

    public abstract Collection<Node> takeNodesBySlots(int var1);

    public abstract NodeAndSlotCounts getNodeAndSlotCountIfSlotsWereTaken(int var1);

    public abstract int nodesAvailable();

    public abstract Collection<Node> takeNodes(int var1);

    public abstract void scheduleAsNeeded(NodePool ... var1);

    public static class RoundRobinSlotScheduler {
        private Map<String, Set<String>> _nodeToComps;
        private HashMap<String, List<ExecutorDetails>> _spreadToSchedule;
        private LinkedList<Set<ExecutorDetails>> _slots;
        private Set<ExecutorDetails> _lastSlot;
        private Cluster _cluster;
        private String _topId;

        public RoundRobinSlotScheduler(TopologyDetails td, int slotsToUse, Cluster cluster) {
            this._topId = td.getId();
            this._cluster = cluster;
            Map<ExecutorDetails, String> execToComp = td.getExecutorToComponent();
            SchedulerAssignment assignment = this._cluster.getAssignmentById(this._topId);
            this._nodeToComps = new HashMap<String, Set<String>>();
            if (assignment != null) {
                Map<ExecutorDetails, WorkerSlot> execToSlot = assignment.getExecutorToSlot();
                for (Map.Entry<ExecutorDetails, WorkerSlot> entry : execToSlot.entrySet()) {
                    String nodeId = entry.getValue().getNodeId();
                    Set<String> comps = this._nodeToComps.get(nodeId);
                    if (comps == null) {
                        comps = new HashSet<String>();
                        this._nodeToComps.put(nodeId, comps);
                    }
                    comps.add(execToComp.get(entry.getKey()));
                }
            }
            this._spreadToSchedule = new HashMap();
            List spreadComps = (List)td.getConf().get("topology.spread.components");
            if (spreadComps != null) {
                for (String comp : spreadComps) {
                    this._spreadToSchedule.put(comp, new ArrayList());
                }
            }
            this._slots = new LinkedList();
            for (int i = 0; i < slotsToUse; ++i) {
                this._slots.add(new HashSet());
            }
            int at = 0;
            for (Map.Entry<String, List<ExecutorDetails>> entry : this._cluster.getNeedsSchedulingComponentToExecutors(td).entrySet()) {
                LOG.debug("Scheduling for {}", (Object)entry.getKey());
                if (this._spreadToSchedule.containsKey(entry.getKey())) {
                    LOG.debug("Saving {} for spread...", (Object)entry.getKey());
                    this._spreadToSchedule.get(entry.getKey()).addAll((Collection<ExecutorDetails>)entry.getValue());
                    continue;
                }
                for (ExecutorDetails ed : entry.getValue()) {
                    LOG.debug("Assigning {} {} to slot {}", new Object[]{entry.getKey(), ed, at});
                    this._slots.get(at).add(ed);
                    if (++at < this._slots.size()) continue;
                    at = 0;
                }
            }
            this._lastSlot = this._slots.get(this._slots.size() - 1);
        }

        public boolean assignSlotTo(Node n) {
            if (this._slots.isEmpty()) {
                return false;
            }
            Set<ExecutorDetails> slot = this._slots.pop();
            if (slot == this._lastSlot) {
                for (Map.Entry<String, List<ExecutorDetails>> entry : this._spreadToSchedule.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    slot.addAll((Collection<ExecutorDetails>)entry.getValue());
                }
            } else {
                String nodeId = n.getId();
                Set<String> nodeComps = this._nodeToComps.get(nodeId);
                if (nodeComps == null) {
                    nodeComps = new HashSet<String>();
                    this._nodeToComps.put(nodeId, nodeComps);
                }
                for (Map.Entry<String, List<ExecutorDetails>> entry : this._spreadToSchedule.entrySet()) {
                    String comp;
                    if (entry.getValue().size() <= 0 || nodeComps.contains(comp = entry.getKey())) continue;
                    nodeComps.add(comp);
                    slot.add(entry.getValue().remove(0));
                }
            }
            n.assign(this._topId, slot, this._cluster);
            return !this._slots.isEmpty();
        }
    }

    public static class NodeAndSlotCounts {
        public final int _nodes;
        public final int _slots;

        public NodeAndSlotCounts(int nodes, int slots) {
            this._nodes = nodes;
            this._slots = slots;
        }
    }
}

