/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.storm.nimbus.IWorkerHeartbeatsRecoveryStrategy;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOutWorkerHeartbeatsRecoveryStrategy
implements IWorkerHeartbeatsRecoveryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TimeOutWorkerHeartbeatsRecoveryStrategy.class);
    private static int NODE_MAX_TIMEOUT_SECS = 600;
    private long startTimeSecs;
    private Set<String> reportedIds;

    @Override
    public void prepare(Map conf) {
        NODE_MAX_TIMEOUT_SECS = ObjectReader.getInt(conf.get("supervisor.worker.heartbeats.max.timeout.secs"), (Integer)600);
        this.startTimeSecs = Time.currentTimeMillis() / 1000L;
        this.reportedIds = new HashSet<String>();
    }

    @Override
    public boolean isReady(Set<String> nodeIds) {
        if (this.exceedsMaxTimeOut()) {
            Set tmp = nodeIds.stream().filter(id -> !this.reportedIds.contains(id)).collect(Collectors.toSet());
            LOG.warn("Failed to recover heartbeats for nodes: {} with timeout {}s", tmp, (Object)NODE_MAX_TIMEOUT_SECS);
            return true;
        }
        return nodeIds.stream().allMatch(id -> this.reportedIds.contains(id));
    }

    @Override
    public void reportNodeId(String nodeId) {
        this.reportedIds.add(nodeId);
    }

    private boolean exceedsMaxTimeOut() {
        return Time.currentTimeMillis() / 1000L - this.startTimeSecs > (long)NODE_MAX_TIMEOUT_SECS;
    }
}

