/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore;

import java.util.Map;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.MetricStore;
import org.apache.storm.metricstore.WorkerMetricsProcessor;

public class MetricStoreConfig {
    public static MetricStore configure(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) throws MetricException {
        try {
            String storeClass = (String)conf.get("storm.metricstore.class");
            MetricStore store = (MetricStore)Class.forName(storeClass).newInstance();
            store.prepare(conf, metricsRegistry);
            return store;
        }
        catch (Exception e) {
            throw new MetricException("Failed to create metric store", e);
        }
    }

    public static WorkerMetricsProcessor configureMetricProcessor(Map conf) throws MetricException {
        try {
            String processorClass = (String)conf.get("storm.metricprocessor.class");
            WorkerMetricsProcessor processor = (WorkerMetricsProcessor)Class.forName(processorClass).newInstance();
            processor.prepare(conf);
            return processor;
        }
        catch (Exception e) {
            throw new MetricException("Failed to create metric processor", e);
        }
    }
}

