/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.ReadClusterState;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.generated.SupervisorAssignments;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeAssignments
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizeAssignments.class);
    private Supervisor supervisor;
    private SupervisorAssignments assignments;
    private ReadClusterState readClusterState;

    public SynchronizeAssignments(Supervisor supervisor, SupervisorAssignments assignments, ReadClusterState readClusterState) {
        this.supervisor = supervisor;
        this.assignments = assignments;
        this.readClusterState = readClusterState;
    }

    private static void assignedAssignmentsToLocal(IStormClusterState clusterState, SupervisorAssignments assignments) {
        if (null == assignments) {
            return;
        }
        HashMap serAssignments = new HashMap();
        for (Map.Entry entry : assignments.get_storm_assignment().entrySet()) {
            serAssignments.put(entry.getKey(), Utils.serialize(entry.getValue()));
        }
        clusterState.syncRemoteAssignments(serAssignments);
    }

    @Override
    public void run() {
        if (null == this.assignments) {
            this.getAssignmentsFromMaster(this.supervisor.getConf(), this.supervisor.getStormClusterState(), this.supervisor.getAssignmentId());
        } else {
            SynchronizeAssignments.assignedAssignmentsToLocal(this.supervisor.getStormClusterState(), this.assignments);
        }
        this.readClusterState.run();
    }

    public void getAssignmentsFromMasterUntilSuccess(Supervisor supervisor) {
        boolean success = false;
        while (!success) {
            try (NimbusClient master2 = NimbusClient.getConfiguredClient(supervisor.getConf());){
                SupervisorAssignments assignments = master2.getClient().getSupervisorAssignments(supervisor.getAssignmentId());
                SynchronizeAssignments.assignedAssignmentsToLocal(supervisor.getStormClusterState(), assignments);
                success = true;
            }
            catch (Exception master2) {
                // empty catch block
            }
            if (success) continue;
            LOG.info("Waiting for a success sync of assignments from master...");
            try {
                Time.sleep((long)5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void getAssignmentsFromMaster(Map conf, IStormClusterState clusterState, String node) {
        if (ConfigUtils.isLocalMode((Map)conf)) {
            try {
                SupervisorAssignments assignments = this.supervisor.getLocalNimbus().getSupervisorAssignments(node);
                SynchronizeAssignments.assignedAssignmentsToLocal(clusterState, assignments);
            }
            catch (TException e) {
                LOG.error("Get assignments from local master exception", (Throwable)e);
            }
        } else {
            try (NimbusClient master = NimbusClient.getConfiguredClient((Map)conf);){
                SupervisorAssignments assignments = master.getClient().getSupervisorAssignments(node);
                LOG.debug("Sync an assignments from master, will start to sync with assignments: {}", (Object)assignments);
                SynchronizeAssignments.assignedAssignmentsToLocal(clusterState, assignments);
            }
            catch (Exception t) {
                LOG.error("Get assignments from master exception", (Throwable)t);
            }
        }
    }
}

