/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.nimbus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.SupervisorWorkerHeartbeat;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.stats.StatsUtil;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatCache {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatCache.class);
    private static final Function<String, ConcurrentHashMap<List<Integer>, ExecutorCache>> MAKE_MAP = k -> new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<List<Integer>, ExecutorCache>> cache = new ConcurrentHashMap();

    @VisibleForTesting
    public void addEmptyTopoForTests(String topoId) {
        this.cache.put(topoId, new ConcurrentHashMap());
    }

    @VisibleForTesting
    public int getNumToposCached() {
        return this.cache.size();
    }

    @VisibleForTesting
    public Set<String> getTopologyIds() {
        return this.cache.keySet();
    }

    public void removeTopo(String topoId) {
        this.cache.remove(topoId);
    }

    public void timeoutOldHeartbeats(String topoId, Integer taskTimeoutSecs) {
        Map topoCache = this.cache.computeIfAbsent(topoId, MAKE_MAP);
        for (ExecutorCache ec : topoCache.values()) {
            ec.updateTimeout(taskTimeoutSecs);
        }
    }

    public void updateFromZkHeartbeat(String topoId, Map<List<Integer>, Map<String, Object>> executorBeats, Set<List<Integer>> allExecutors, Integer timeout) {
        Map topoCache = this.cache.computeIfAbsent(topoId, MAKE_MAP);
        if (executorBeats == null) {
            executorBeats = new HashMap<List<Integer>, Map<String, Object>>();
        }
        for (List<Integer> executor : allExecutors) {
            Map<String, Object> newBeat = executorBeats.get(executor);
            ExecutorCache currBeat = topoCache.computeIfAbsent(executor, k -> new ExecutorCache(newBeat));
            currBeat.updateFromHb(timeout, newBeat);
        }
    }

    public void updateHeartbeat(SupervisorWorkerHeartbeat workerHeartbeat, Integer taskTimeoutSecs) {
        Map<List<Integer>, Map<String, Object>> executorBeats = StatsUtil.convertWorkerBeats(workerHeartbeat);
        String topoId = workerHeartbeat.get_storm_id();
        Map topoCache = this.cache.computeIfAbsent(topoId, MAKE_MAP);
        for (ExecutorInfo executorInfo : workerHeartbeat.get_executors()) {
            List<Integer> executor = Arrays.asList(executorInfo.get_task_start(), executorInfo.get_task_end());
            Map<String, Object> newBeat = executorBeats.get(executor);
            ExecutorCache currBeat = topoCache.computeIfAbsent(executor, k -> new ExecutorCache(newBeat));
            currBeat.updateFromHb(taskTimeoutSecs, newBeat);
        }
    }

    public Set<List<Integer>> getAliveExecutors(String topoId, Set<List<Integer>> allExecutors, Assignment assignment, int taskLaunchSecs) {
        Map topoCache = this.cache.computeIfAbsent(topoId, MAKE_MAP);
        LOG.debug("Computing alive executors for {}\nExecutors: {}\nAssignment: {}\nHeartbeat cache: {}", new Object[]{topoId, allExecutors, assignment, topoCache});
        HashSet<List<Integer>> ret = new HashSet<List<Integer>>();
        Map execToStartTimes = assignment.get_executor_start_time_secs();
        for (List<Integer> exec : allExecutors) {
            Integer delta;
            ArrayList<Long> longExec = new ArrayList<Long>(exec.size());
            for (Integer num : exec) {
                longExec.add(num.longValue());
            }
            Long startTime = (Long)execToStartTimes.get(longExec);
            ExecutorCache executorCache = (ExecutorCache)topoCache.get(exec);
            boolean isTimedOut = executorCache == null ? true : executorCache.isTimedOut();
            Integer n = delta = startTime == null ? null : Integer.valueOf(Time.deltaSecs((int)startTime.intValue()));
            if (!(startTime == null || delta >= taskLaunchSecs && isTimedOut)) {
                ret.add(exec);
                continue;
            }
            LOG.info("Executor {}:{} not alive", (Object)topoId, exec);
        }
        return ret;
    }

    private static class ExecutorCache {
        private Boolean isTimedOut;
        private Integer nimbusTimeSecs;
        private Integer executorReportedTimeSecs;

        public ExecutorCache(Map<String, Object> newBeat) {
            this.executorReportedTimeSecs = newBeat != null ? (Integer)newBeat.getOrDefault("time-secs", 0) : Integer.valueOf(0);
            this.nimbusTimeSecs = Time.currentTimeSecs();
            this.isTimedOut = false;
        }

        public synchronized Boolean isTimedOut() {
            return this.isTimedOut;
        }

        public synchronized Integer getNimbusTimeSecs() {
            return this.nimbusTimeSecs;
        }

        public synchronized void updateTimeout(Integer timeout) {
            this.isTimedOut = Time.deltaSecs((int)this.getNimbusTimeSecs()) >= timeout;
        }

        public synchronized void updateFromHb(Integer timeout, Map<String, Object> newBeat) {
            if (newBeat != null) {
                Integer newReportedTime = (Integer)newBeat.getOrDefault("time-secs", 0);
                if (!newReportedTime.equals(this.executorReportedTimeSecs)) {
                    this.nimbusTimeSecs = Time.currentTimeSecs();
                }
                this.executorReportedTimeSecs = newReportedTime;
            }
            this.updateTimeout(timeout);
        }
    }
}

