/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics.reporters;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvPreparableReporter
implements PreparableReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CsvPreparableReporter.class);
    CsvReporter reporter = null;

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> topoConf) {
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing...");
        CsvReporter.Builder builder = CsvReporter.forRegistry((MetricRegistry)metricsRegistry);
        Locale locale = ClientMetricsUtils.getMetricsReporterLocale(topoConf);
        if (locale != null) {
            builder.formatFor(locale);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(topoConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = ClientMetricsUtils.getMetricsDurationUnit(topoConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        File csvMetricsDir = MetricsUtils.getCsvLogDir(topoConf);
        this.reporter = builder.build(csvMetricsDir);
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start(10L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.report();
        this.reporter.stop();
    }
}

