/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.LogLevel;
import org.apache.storm.generated.LogLevelAction;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetLogLevel {
    private static final Logger LOG = LoggerFactory.getLogger(SetLogLevel.class);

    public static void main(String[] args) throws Exception {
        Map removeLogLevel;
        Map<String, Object> cl = CLI.opt("l", "log-setting", null, new LogLevelsParser(LogLevelAction.UPDATE), CLI.INTO_MAP).opt("r", "remove-log-setting", null, new LogLevelsParser(LogLevelAction.REMOVE), CLI.INTO_MAP).arg("topologyName", CLI.FIRST_WINS).parse(args);
        final String topologyName = (String)cl.get("topologyName");
        final LogConfig logConfig = new LogConfig();
        HashMap logLevelMap = new HashMap();
        Map updateLogLevel = (Map)cl.get("l");
        if (null != updateLogLevel) {
            logLevelMap.putAll(updateLogLevel);
        }
        if (null != (removeLogLevel = (Map)cl.get("r"))) {
            logLevelMap.putAll(removeLogLevel);
        }
        for (Map.Entry entry : logLevelMap.entrySet()) {
            logConfig.put_to_named_logger_level((String)entry.getKey(), (LogLevel)entry.getValue());
        }
        NimbusClient.withConfiguredClient((NimbusClient.WithNimbus)new NimbusClient.WithNimbus(){

            public void run(Nimbus.Iface nimbus) throws Exception {
                String topologyId = Utils.getTopologyId((String)topologyName, (Nimbus.Iface)nimbus);
                if (null == topologyId) {
                    throw new IllegalArgumentException(topologyName + " is not a running topology");
                }
                nimbus.setLogConfig(topologyId, logConfig);
                LOG.info("Log config {} is sent for topology {}", (Object)logConfig, (Object)topologyName);
            }
        });
    }

    static final class LogLevelsParser
    implements CLI.Parse {
        private LogLevelAction action;

        public LogLevelsParser(LogLevelAction action) {
            this.action = action;
        }

        @Override
        public Object parse(String value) {
            LogLevel logLevel = new LogLevel();
            logLevel.set_action(this.action);
            String name = null;
            if (this.action == LogLevelAction.REMOVE) {
                name = value;
            } else {
                String[] splits = value.split("=");
                Preconditions.checkArgument((splits.length == 2 ? 1 : 0) != 0, (String)"Invalid log string '%s'", (Object)value);
                name = splits[0];
                splits = splits[1].split(":");
                Integer timeout = 0;
                Level level = Level.valueOf((String)splits[0]);
                logLevel.set_target_log_level(level.toString());
                if (splits.length > 1) {
                    timeout = Integer.parseInt(splits[1]);
                }
                logLevel.set_reset_log_level_timeout_secs(timeout.intValue());
            }
            HashMap<String, LogLevel> result = new HashMap<String, LogLevel>();
            result.put(name, logLevel);
            return result;
        }
    }
}

