/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI {
    public static final Parse AS_INT = value -> Integer.valueOf(value);
    public static final Parse AS_STRING = value -> value;
    public static final Assoc LAST_WINS = (current, value) -> value;
    public static final Assoc FIRST_WINS = (current, value) -> current == null ? value : current;
    public static final Assoc INTO_LIST = (current, value) -> {
        if (current == null) {
            current = new ArrayList();
        }
        ((List)current).add(value);
        return current;
    };
    public static final Assoc INTO_MAP = (current, value) -> {
        if (null == current) {
            current = new HashMap();
        }
        ((Map)current).putAll((Map)value);
        return current;
    };
    private static final Logger LOG = LoggerFactory.getLogger(CLI.class);

    public static CLIBuilder opt(String shortName, String longName, Object defaultValue) {
        return new CLIBuilder().opt(shortName, longName, defaultValue);
    }

    public static CLIBuilder opt(String shortName, String longName, Object defaultValue, Parse parse) {
        return new CLIBuilder().opt(shortName, longName, defaultValue, parse);
    }

    public static CLIBuilder opt(String shortName, String longName, Object defaultValue, Parse parse, Assoc assoc) {
        return new CLIBuilder().opt(shortName, longName, defaultValue, parse, assoc);
    }

    public static CLIBuilder boolOpt(String shortName, String longName) {
        return new CLIBuilder().boolOpt(shortName, longName);
    }

    public static CLIBuilder arg(String name) {
        return new CLIBuilder().arg(name);
    }

    public static CLIBuilder arg(String name, Assoc assoc) {
        return new CLIBuilder().arg(name, assoc);
    }

    public static CLIBuilder arg(String name, Parse parse) {
        return new CLIBuilder().arg(name, parse);
    }

    public static CLIBuilder arg(String name, Parse parse, Assoc assoc) {
        return new CLIBuilder().arg(name, parse, assoc);
    }

    public static CLIBuilder optionalArg(String name) {
        return new CLIBuilder().optionalArg(name);
    }

    public static CLIBuilder optionalArg(String name, Assoc assoc) {
        return new CLIBuilder().optionalArg(name, assoc);
    }

    public static CLIBuilder optionalArg(String name, Parse parse) {
        return new CLIBuilder().optionalArg(name, parse);
    }

    public static CLIBuilder optionalArg(String name, Parse parse, Assoc assoc) {
        return new CLIBuilder().optionalArg(name, parse, assoc);
    }

    public static class CLIBuilder {
        private final ArrayList<Opt> opts = new ArrayList();
        private final ArrayList<Arg> args = new ArrayList();
        private final ArrayList<Arg> optionalArgs = new ArrayList();

        public CLIBuilder opt(String shortName, String longName, Object defaultValue) {
            return this.opt(shortName, longName, defaultValue, null, null);
        }

        public CLIBuilder opt(String shortName, String longName, Object defaultValue, Parse parse) {
            return this.opt(shortName, longName, defaultValue, parse, null);
        }

        public CLIBuilder opt(String shortName, String longName, Object defaultValue, Parse parse, Assoc assoc) {
            this.opts.add(new Opt(shortName, longName, defaultValue, parse, assoc, false));
            return this;
        }

        public CLIBuilder boolOpt(String shortName, String longName) {
            this.opts.add(new Opt(shortName, longName, false, null, null, true));
            return this;
        }

        public CLIBuilder arg(String name) {
            return this.arg(name, null, null);
        }

        public CLIBuilder arg(String name, Assoc assoc) {
            return this.arg(name, null, assoc);
        }

        public CLIBuilder arg(String name, Parse parse) {
            return this.arg(name, parse, null);
        }

        public CLIBuilder arg(String name, Parse parse, Assoc assoc) {
            if (!this.optionalArgs.isEmpty()) {
                throw new IllegalStateException("Cannot have a required argument after adding in an optional argument");
            }
            this.args.add(new Arg(name, parse, assoc));
            return this;
        }

        public CLIBuilder optionalArg(String name) {
            return this.optionalArg(name, null, null);
        }

        public CLIBuilder optionalArg(String name, Assoc assoc) {
            return this.optionalArg(name, null, assoc);
        }

        public CLIBuilder optionalArg(String name, Parse parse) {
            return this.optionalArg(name, parse, null);
        }

        public CLIBuilder optionalArg(String name, Parse parse, Assoc assoc) {
            this.optionalArgs.add(new Arg(name, parse, assoc));
            return this;
        }

        public Map<String, Object> parse(String ... rawArgs) throws Exception {
            Options options = new Options();
            for (Opt opt : this.opts) {
                if (opt.noValue) {
                    options.addOption(Option.builder((String)opt.shortName).longOpt(opt.longName).hasArg(false).build());
                    continue;
                }
                options.addOption(Option.builder((String)opt.shortName).longOpt(opt.longName).hasArg().build());
            }
            DefaultParser parser = new DefaultParser();
            CommandLine cl = parser.parse(options, rawArgs);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            for (Opt opt : this.opts) {
                if (opt.noValue) {
                    ret.put(opt.shortName, cl.hasOption(opt.shortName));
                    continue;
                }
                Object current = null;
                String[] strings = cl.getOptionValues(opt.shortName);
                if (strings != null) {
                    for (String val : strings) {
                        current = opt.process(current, val);
                    }
                }
                if (current == null) {
                    current = opt.defaultValue;
                }
                ret.put(opt.shortName, current);
            }
            ArrayList<Arg> fullArgs = new ArrayList<Arg>(this.args);
            fullArgs.addAll(this.optionalArgs);
            List stringArgs = cl.getArgList();
            if (this.args.size() > stringArgs.size()) {
                throw new RuntimeException("Wrong number of arguments at least " + this.args.size() + " expected, but only " + stringArgs.size() + " found");
            }
            int stringArgIndex = 0;
            if (fullArgs.size() > 0) {
                for (int argIndex = 0; argIndex < fullArgs.size(); ++argIndex) {
                    int maxStringIndex;
                    Arg arg = (Arg)fullArgs.get(argIndex);
                    boolean isLastArg = argIndex == fullArgs.size() - 1;
                    Object current = null;
                    int n = maxStringIndex = isLastArg ? stringArgs.size() : stringArgIndex + 1;
                    while (stringArgIndex < maxStringIndex) {
                        current = arg.process(current, (String)stringArgs.get(stringArgIndex));
                        ++stringArgIndex;
                    }
                    ret.put(arg.name, current);
                }
            } else {
                ret.put("ARGS", stringArgs);
            }
            return ret;
        }
    }

    private static class Arg {
        final String name;
        final Parse parse;
        final Assoc assoc;

        public Arg(String name, Parse parse, Assoc assoc) {
            this.name = name;
            this.parse = parse == null ? AS_STRING : parse;
            this.assoc = assoc == null ? INTO_LIST : assoc;
        }

        public Object process(Object current, String value) {
            return this.assoc.assoc(current, this.parse.parse(value));
        }
    }

    private static class Opt {
        final String shortName;
        final String longName;
        final Object defaultValue;
        final Parse parse;
        final Assoc assoc;
        final boolean noValue;

        public Opt(String shortName, String longName, Object defaultValue, Parse parse, Assoc assoc, boolean noValue) {
            this.shortName = shortName;
            this.longName = longName;
            this.defaultValue = defaultValue;
            this.parse = parse == null ? AS_STRING : parse;
            this.assoc = assoc == null ? LAST_WINS : assoc;
            this.noValue = noValue;
        }

        public Object process(Object current, String value) {
            return this.assoc.assoc(current, this.parse.parse(value));
        }
    }

    public static interface Assoc {
        public Object assoc(Object var1, Object var2);
    }

    public static interface Parse {
        public Object parse(String var1);
    }
}

