/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.util;

import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import sun.misc.Unsafe;

public class FSTUtil {
    static Object[] EmptyObjArray = new Object[10000];
    static ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    public static Unsafe unFlaggedUnsafe = FSTUtil.getUnsafe();
    public static final long refoff;
    public static final long refscal;
    public static final long bufoff;
    public static final long choff;
    public static final long intoff;
    public static final long longoff;
    public static final long doubleoff;
    public static final long floatoff;
    public static final long intscal;
    public static final long longscal;
    public static final long chscal;
    public static final long floatscal;
    public static final long doublescal;

    public static void clear(int[] arr) {
        Arrays.fill(arr, 0);
    }

    public static void clear(Object[] arr) {
        int arrlen = arr.length;
        FSTUtil.clear(arr, arrlen);
    }

    public static void clear(Object[] arr, int arrlen) {
        int count = 0;
        int length = EmptyObjArray.length;
        while (arrlen - count > length) {
            System.arraycopy(EmptyObjArray, 0, arr, count, length);
            count += length;
        }
        System.arraycopy(EmptyObjArray, 0, arr, count, arrlen - count);
    }

    public static String toString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        return th.getClass().getSimpleName() + ":" + th.getMessage() + "\n" + sw.toString();
    }

    public static <T extends Throwable> void rethrow(Throwable exception) throws T {
        throw exception;
    }

    public static String getPackage(Class clazz) {
        String s = clazz.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        if ((i = s.lastIndexOf(46)) >= 0) {
            return s.substring(0, i);
        }
        return "";
    }

    public static boolean isPackEq(Class clazz1, Class clazz2) {
        return FSTUtil.getPackage(clazz1).equals(FSTUtil.getPackage(clazz2));
    }

    public static Method findPrivateMethod(Class clazz, String methName, Class[] clazzArgs, Class retClazz) {
        try {
            Method m = clazz.getDeclaredMethod(methName, clazzArgs);
            int modif = m.getModifiers();
            if (m.getReturnType() == retClazz && (modif & 2) != 0 && (modif & 8) == 0) {
                m.setAccessible(true);
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method findDerivedMethod(Class clazz, String metnam, Class[] argClzz, Class retClz) {
        Class defCl;
        Method m = null;
        for (defCl = clazz; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                m = defCl.getDeclaredMethod(metnam, argClzz);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (m == null) {
            return null;
        }
        if (m.getReturnType() != retClz) {
            return null;
        }
        int mods = m.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            m.setAccessible(true);
            return m;
        }
        if ((mods & 2) != 0) {
            m.setAccessible(true);
            if (clazz == defCl) {
                return m;
            }
            return null;
        }
        m.setAccessible(true);
        if (FSTUtil.isPackEq(clazz, defCl)) {
            return m;
        }
        return null;
    }

    public static void printEx(Throwable e) {
        while (e.getCause() != null && e.getCause() != e) {
            e = e.getCause();
        }
        e.printStackTrace();
    }

    public static boolean isPrimitiveArray(Class c) {
        Class<?> componentType = c.getComponentType();
        if (componentType == null) {
            return c.isPrimitive();
        }
        return FSTUtil.isPrimitiveArray(c.getComponentType());
    }

    public static Unsafe getUnsafe() {
        try {
            if (unFlaggedUnsafe != null) {
                return unFlaggedUnsafe;
            }
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int writeSignedVarInt(int value, byte[] out, int index) {
        return FSTUtil.writeUnsignedVarInt(value << 1 ^ value >> 31, out, index);
    }

    public static int writeUnsignedVarInt(int value, byte[] out, int index) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out[index++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out[index++] = (byte)(value & 0x7F);
        return index;
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = FSTUtil.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static byte[] readAll(InputStream is) throws Exception {
        int pos = 0;
        byte[] buffer = new byte[1024];
        while (true) {
            int byt;
            int toRead;
            if (pos >= buffer.length) {
                toRead = buffer.length * 2;
                if (buffer.length < pos + toRead) {
                    buffer = Arrays.copyOf(buffer, pos + toRead);
                }
            } else {
                toRead = buffer.length - pos;
            }
            if ((byt = is.read(buffer, pos, toRead)) < 0) {
                if (pos == buffer.length) break;
                buffer = Arrays.copyOf(buffer, pos);
                break;
            }
            pos += byt;
        }
        return buffer;
    }

    public static int nextPow2(int num) {
        return 1 << (num == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(num - 1));
    }

    public static Class getRealEnumClass(Class enumClass) {
        if (enumClass.isAnonymousClass()) {
            return enumClass.getSuperclass();
        }
        return enumClass;
    }

    static {
        if (unFlaggedUnsafe != null) {
            refoff = unFlaggedUnsafe.arrayBaseOffset(Object[].class);
            bufoff = unFlaggedUnsafe.arrayBaseOffset(byte[].class);
            intoff = unFlaggedUnsafe.arrayBaseOffset(int[].class);
            longoff = unFlaggedUnsafe.arrayBaseOffset(long[].class);
            longscal = unFlaggedUnsafe.arrayIndexScale(long[].class);
            intscal = unFlaggedUnsafe.arrayIndexScale(int[].class);
            chscal = unFlaggedUnsafe.arrayIndexScale(char[].class);
            refscal = unFlaggedUnsafe.arrayIndexScale(Object[].class);
            choff = unFlaggedUnsafe.arrayBaseOffset(char[].class);
            doubleoff = unFlaggedUnsafe.arrayBaseOffset(double[].class);
            doublescal = unFlaggedUnsafe.arrayIndexScale(double[].class);
            floatoff = unFlaggedUnsafe.arrayBaseOffset(float[].class);
            floatscal = unFlaggedUnsafe.arrayIndexScale(float[].class);
        } else {
            refscal = 0L;
            refoff = 0L;
            longoff = 0L;
            longscal = 0L;
            bufoff = 0L;
            intoff = 0L;
            intscal = 0L;
            choff = 0L;
            chscal = 0L;
            doublescal = 0L;
            doubleoff = 0L;
            floatscal = 0L;
            floatoff = 0L;
        }
    }
}

