/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.Mutator;

public class MutatorImpl
implements Mutator {
    private final long transactionId;
    private final Path partitionPath;
    private final int bucketId;
    private final Configuration configuration;
    private final int recordIdColumn;
    private final ObjectInspector objectInspector;
    private RecordUpdater updater;

    public MutatorImpl(Configuration configuration, int recordIdColumn, ObjectInspector objectInspector, AcidOutputFormat<?, ?> outputFormat, long transactionId, Path partitionPath, int bucketId) throws IOException {
        this.configuration = configuration;
        this.recordIdColumn = recordIdColumn;
        this.objectInspector = objectInspector;
        this.transactionId = transactionId;
        this.partitionPath = partitionPath;
        this.bucketId = bucketId;
        this.updater = this.createRecordUpdater(outputFormat);
    }

    @Override
    public void insert(Object record) throws IOException {
        this.updater.insert(this.transactionId, record);
    }

    @Override
    public void update(Object record) throws IOException {
        this.updater.update(this.transactionId, record);
    }

    @Override
    public void delete(Object record) throws IOException {
        this.updater.delete(this.transactionId, record);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.updater.close(false);
        this.updater = null;
    }

    public String toString() {
        return "ObjectInspectorMutator [transactionId=" + this.transactionId + ", partitionPath=" + this.partitionPath + ", bucketId=" + this.bucketId + "]";
    }

    protected RecordUpdater createRecordUpdater(AcidOutputFormat<?, ?> outputFormat) throws IOException {
        return outputFormat.getRecordUpdater(this.partitionPath, new AcidOutputFormat.Options(this.configuration).inspector(this.objectInspector).bucket(this.bucketId).minimumTransactionId(this.transactionId).maximumTransactionId(this.transactionId).recordIdColumn(this.recordIdColumn).finalDestination(this.partitionPath).statementId(-1));
    }
}

