/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionCreationException;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.WorkerException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaStorePartitionHelper
implements PartitionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStorePartitionHelper.class);
    private final IMetaStoreClient metaStoreClient;
    private final String databaseName;
    private final String tableName;
    private final Path tablePath;

    MetaStorePartitionHelper(IMetaStoreClient metaStoreClient, String databaseName, String tableName, Path tablePath) {
        this.metaStoreClient = metaStoreClient;
        this.tablePath = tablePath;
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    @Override
    public Path getPathForPartition(List<String> newPartitionValues) throws WorkerException {
        if (newPartitionValues.isEmpty()) {
            LOG.debug("Using path {} for unpartitioned table {}.{}", new Object[]{this.tablePath, this.databaseName, this.tableName});
            return this.tablePath;
        }
        try {
            String location = this.metaStoreClient.getPartition(this.databaseName, this.tableName, newPartitionValues).getSd().getLocation();
            LOG.debug("Found path {} for partition {}", (Object)location, newPartitionValues);
            return new Path(location);
        }
        catch (NoSuchObjectException e) {
            throw new WorkerException("Table not found '" + this.databaseName + "." + this.tableName + "'.", e);
        }
        catch (TException e) {
            throw new WorkerException("Failed to get path for partitions '" + newPartitionValues + "' on table '" + this.databaseName + "." + this.tableName + "' with meta store: " + this.metaStoreClient, e);
        }
    }

    @Override
    public void createPartitionIfNotExists(List<String> newPartitionValues) throws WorkerException {
        if (newPartitionValues.isEmpty()) {
            return;
        }
        try {
            LOG.debug("Attempting to create partition (if not exists) {}.{}:{}", new Object[]{this.databaseName, this.tableName, newPartitionValues});
            Table table = this.metaStoreClient.getTable(this.databaseName, this.tableName);
            Partition partition = new Partition();
            partition.setDbName(table.getDbName());
            partition.setTableName(table.getTableName());
            StorageDescriptor partitionSd = new StorageDescriptor(table.getSd());
            partitionSd.setLocation(table.getSd().getLocation() + "/" + Warehouse.makePartName((List)table.getPartitionKeys(), newPartitionValues));
            partition.setSd(partitionSd);
            partition.setValues(newPartitionValues);
            this.metaStoreClient.add_partition(partition);
        }
        catch (AlreadyExistsException e) {
            LOG.debug("Partition already exisits: {}.{}:{}", new Object[]{this.databaseName, this.tableName, newPartitionValues});
        }
        catch (NoSuchObjectException e) {
            LOG.error("Failed to create partition : " + newPartitionValues, (Throwable)e);
            throw new PartitionCreationException("Table not found '" + this.databaseName + "." + this.tableName + "'.", e);
        }
        catch (TException e) {
            LOG.error("Failed to create partition : " + newPartitionValues, (Throwable)e);
            throw new PartitionCreationException("Failed to create partition '" + newPartitionValues + "' on table '" + this.databaseName + "." + this.tableName + "'", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.metaStoreClient.close();
    }
}

