/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.util.List;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;

public class BucketIdResolverImpl
implements BucketIdResolver {
    private static final long INVALID_TRANSACTION_ID = -1L;
    private static final long INVALID_ROW_ID = -1L;
    private final SettableStructObjectInspector structObjectInspector;
    private final StructField[] bucketFields;
    private final int totalBuckets;
    private final StructField recordIdentifierField;

    public BucketIdResolverImpl(ObjectInspector objectInspector, int recordIdColumn, int totalBuckets, int[] bucketColumns) {
        this.totalBuckets = totalBuckets;
        if (!(objectInspector instanceof SettableStructObjectInspector)) {
            throw new IllegalArgumentException("Serious problem, expected a StructObjectInspector, but got a " + objectInspector.getClass().getName());
        }
        if (bucketColumns.length < 1) {
            throw new IllegalArgumentException("No bucket column indexes set.");
        }
        this.structObjectInspector = (SettableStructObjectInspector)objectInspector;
        List structFields = this.structObjectInspector.getAllStructFieldRefs();
        this.recordIdentifierField = (StructField)structFields.get(recordIdColumn);
        this.bucketFields = new StructField[bucketColumns.length];
        for (int i = 0; i < bucketColumns.length; ++i) {
            int bucketColumnsIndex = bucketColumns[i];
            this.bucketFields[i] = (StructField)structFields.get(bucketColumnsIndex);
        }
    }

    @Override
    public Object attachBucketIdToRecord(Object record) {
        int bucketId = this.computeBucketId(record);
        RecordIdentifier recordIdentifier = new RecordIdentifier(-1L, bucketId, -1L);
        this.structObjectInspector.setStructFieldData(record, this.recordIdentifierField, (Object)recordIdentifier);
        return record;
    }

    @Override
    public int computeBucketId(Object record) {
        Object[] bucketFieldValues = new Object[this.bucketFields.length];
        ObjectInspector[] bucketFiledInspectors = new ObjectInspector[this.bucketFields.length];
        for (int columnIndex = 0; columnIndex < this.bucketFields.length; ++columnIndex) {
            bucketFieldValues[columnIndex] = this.structObjectInspector.getStructFieldData(record, this.bucketFields[columnIndex]);
            bucketFiledInspectors[columnIndex] = this.bucketFields[columnIndex].getFieldObjectInspector();
        }
        return ObjectInspectorUtils.getBucketNumber((Object[])bucketFieldValues, (ObjectInspector[])bucketFiledInspectors, (int)this.totalBuckets);
    }
}

