/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.DelimitedInputWriter;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingConnection;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordWriter
implements RecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractRecordWriter.class.getName());
    final HiveConf conf;
    final HiveEndPoint endPoint;
    final Table tbl;
    final IMetaStoreClient msClient;
    protected final List<Integer> bucketIds;
    ArrayList<RecordUpdater> updaters = null;
    public final int totalBuckets;
    private final Path partitionPath;
    final AcidOutputFormat<?, ?> outf;
    private Object[] bucketFieldData;
    private Long curBatchMinTxnId;
    private Long curBatchMaxTxnId;

    protected AbstractRecordWriter(HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, StreamingException {
        this(endPoint, conf, null);
    }

    protected AbstractRecordWriter(HiveEndPoint endPoint2, HiveConf conf, StreamingConnection conn) throws StreamingException {
        this.endPoint = endPoint2;
        this.conf = conf != null ? conf : HiveEndPoint.createHiveConf(DelimitedInputWriter.class, this.endPoint.metaStoreUri);
        try {
            UserGroupInformation ugi;
            this.msClient = HCatUtil.getHiveMetastoreClient((HiveConf)this.conf);
            UserGroupInformation userGroupInformation = ugi = conn != null ? conn.getUserGroupInformation() : null;
            if (ugi == null) {
                this.tbl = this.msClient.getTable(this.endPoint.database, this.endPoint.table);
                this.partitionPath = this.getPathForEndPoint(this.msClient, this.endPoint);
            } else {
                TableWriterPair twp = (TableWriterPair)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TableWriterPair>(){

                    @Override
                    public TableWriterPair run() throws Exception {
                        return new TableWriterPair(AbstractRecordWriter.this.msClient.getTable(AbstractRecordWriter.this.endPoint.database, AbstractRecordWriter.this.endPoint.table), AbstractRecordWriter.this.getPathForEndPoint(AbstractRecordWriter.this.msClient, AbstractRecordWriter.this.endPoint));
                    }
                });
                this.tbl = twp.tbl;
                this.partitionPath = twp.partitionPath;
            }
            this.totalBuckets = this.tbl.getSd().getNumBuckets();
            if (this.totalBuckets <= 0) {
                throw new StreamingException("Cannot stream to table that has not been bucketed : " + this.endPoint);
            }
            this.bucketIds = this.getBucketColIDs(this.tbl.getSd().getBucketCols(), this.tbl.getSd().getCols());
            this.bucketFieldData = new Object[this.bucketIds.size()];
            String outFormatName = this.tbl.getSd().getOutputFormat();
            this.outf = (AcidOutputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)outFormatName), (Configuration)conf);
            this.bucketFieldData = new Object[this.bucketIds.size()];
        }
        catch (InterruptedException e) {
            throw new StreamingException(endPoint2.toString(), e);
        }
        catch (MetaException | NoSuchObjectException e) {
            throw new ConnectionError(endPoint2, (Exception)e);
        }
        catch (IOException | ClassNotFoundException | TException e) {
            throw new StreamingException(e.getMessage(), (Exception)e);
        }
    }

    String getWatermark() {
        return this.partitionPath + " txnIds[" + this.curBatchMinTxnId + "," + this.curBatchMaxTxnId + "]";
    }

    private List<Integer> getBucketColIDs(List<String> bucketCols, List<FieldSchema> cols) {
        ArrayList<Integer> result = new ArrayList<Integer>(bucketCols.size());
        HashSet<String> bucketSet = new HashSet<String>(bucketCols);
        for (int i = 0; i < cols.size(); ++i) {
            if (!bucketSet.contains(cols.get(i).getName())) continue;
            result.add(i);
        }
        return result;
    }

    public abstract AbstractSerDe getSerde() throws SerializationError;

    public abstract Object encode(byte[] var1) throws SerializationError;

    protected abstract ObjectInspector[] getBucketObjectInspectors();

    protected abstract StructObjectInspector getRecordObjectInspector();

    protected abstract StructField[] getBucketStructFields();

    protected int getBucket(Object row) throws SerializationError {
        ObjectInspector[] inspectors = this.getBucketObjectInspectors();
        Object[] bucketFields = this.getBucketFields(row);
        return ObjectInspectorUtils.getBucketNumber((Object[])bucketFields, (ObjectInspector[])inspectors, (int)this.totalBuckets);
    }

    @Override
    public void flush() throws StreamingIOFailure {
        try {
            for (RecordUpdater updater : this.updaters) {
                if (updater == null) continue;
                updater.flush();
            }
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Unable to flush recordUpdater", e);
        }
    }

    @Override
    public void clear() throws StreamingIOFailure {
    }

    @Override
    public void newBatch(Long minTxnId, Long maxTxnID) throws StreamingIOFailure, SerializationError {
        this.curBatchMinTxnId = minTxnId;
        this.curBatchMaxTxnId = maxTxnID;
        this.updaters = new ArrayList(this.totalBuckets);
        for (int bucket = 0; bucket < this.totalBuckets; ++bucket) {
            this.updaters.add(bucket, null);
        }
    }

    @Override
    public void closeBatch() throws StreamingIOFailure {
        boolean haveError = false;
        for (RecordUpdater updater : this.updaters) {
            if (updater == null) continue;
            try {
                updater.close(false);
            }
            catch (Exception ex) {
                haveError = true;
                LOG.error("Unable to close " + updater + " due to: " + ex.getMessage(), (Throwable)ex);
            }
        }
        this.updaters.clear();
        if (haveError) {
            throw new StreamingIOFailure("Encountered errors while closing (see logs) " + this.getWatermark());
        }
    }

    protected static ObjectInspector[] getObjectInspectorsForBucketedCols(List<Integer> bucketIds, StructObjectInspector recordObjInspector) throws SerializationError {
        ObjectInspector[] result = new ObjectInspector[bucketIds.size()];
        for (int i = 0; i < bucketIds.size(); ++i) {
            int bucketId = bucketIds.get(i);
            result[i] = ((StructField)recordObjInspector.getAllStructFieldRefs().get(bucketId)).getFieldObjectInspector();
        }
        return result;
    }

    private Object[] getBucketFields(Object row) throws SerializationError {
        StructObjectInspector recordObjInspector = this.getRecordObjectInspector();
        StructField[] bucketStructFields = this.getBucketStructFields();
        for (int i = 0; i < this.bucketIds.size(); ++i) {
            this.bucketFieldData[i] = recordObjInspector.getStructFieldData(row, bucketStructFields[i]);
        }
        return this.bucketFieldData;
    }

    private RecordUpdater createRecordUpdater(int bucketId, Long minTxnId, Long maxTxnID) throws IOException, SerializationError {
        try {
            Properties tblProperties = new Properties();
            tblProperties.putAll((Map<?, ?>)this.tbl.getParameters());
            return this.outf.getRecordUpdater(this.partitionPath, new AcidOutputFormat.Options((Configuration)this.conf).inspector(this.getSerde().getObjectInspector()).bucket(bucketId).tableProperties(tblProperties).minimumTransactionId(minTxnId.longValue()).maximumTransactionId(maxTxnID.longValue()).statementId(-1).finalDestination(this.partitionPath));
        }
        catch (SerDeException e) {
            throw new SerializationError("Failed to get object inspector from Serde " + this.getSerde().getClass().getName(), (Exception)((Object)e));
        }
    }

    RecordUpdater getRecordUpdater(int bucketId) throws StreamingIOFailure, SerializationError {
        RecordUpdater recordUpdater = this.updaters.get(bucketId);
        if (recordUpdater == null) {
            try {
                recordUpdater = this.createRecordUpdater(bucketId, this.curBatchMinTxnId, this.curBatchMaxTxnId);
            }
            catch (IOException e) {
                String errMsg = "Failed creating RecordUpdater for " + this.getWatermark();
                LOG.error(errMsg, (Throwable)e);
                throw new StreamingIOFailure(errMsg, e);
            }
            this.updaters.set(bucketId, recordUpdater);
        }
        return recordUpdater;
    }

    private Path getPathForEndPoint(IMetaStoreClient msClient, HiveEndPoint endPoint) throws StreamingException {
        try {
            String location = endPoint.partitionVals == null || endPoint.partitionVals.isEmpty() ? msClient.getTable(endPoint.database, endPoint.table).getSd().getLocation() : msClient.getPartition(endPoint.database, endPoint.table, endPoint.partitionVals).getSd().getLocation();
            return new Path(location);
        }
        catch (TException e) {
            throw new StreamingException(e.getMessage() + ". Unable to get path for end point: " + endPoint.partitionVals, (Exception)((Object)e));
        }
    }

    private static final class TableWriterPair {
        private final Table tbl;
        private final Path partitionPath;

        TableWriterPair(Table t, Path p) {
            this.tbl = t;
            this.partitionPath = p;
        }
    }
}

