/*
 * Decompiled with CFR 0.152.
 */
package org.jamon;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jamon.AbstractTemplateProxy;
import org.jamon.AbstractTemplateReplacer;
import org.jamon.annotations.Replaceable;
import org.jamon.annotations.Replaces;

public class FixedTemplateReplacer
extends AbstractTemplateReplacer {
    private final Map<Class<? extends AbstractTemplateProxy>, AbstractTemplateProxy.ReplacementConstructor> replacementConstructors;

    public FixedTemplateReplacer(Collection<Class<? extends AbstractTemplateProxy>> replacements) {
        this.replacementConstructors = new HashMap<Class<? extends AbstractTemplateProxy>, AbstractTemplateProxy.ReplacementConstructor>(replacements.size());
        for (Class<? extends AbstractTemplateProxy> replacingTemplate : replacements) {
            Replaces replaces = replacingTemplate.getAnnotation(Replaces.class);
            if (replaces == null) {
                throw new IllegalArgumentException("Provided replacement template " + replacingTemplate.getName() + " is not declared to replace anything");
            }
            Class<? extends AbstractTemplateProxy> replacedTemplate = replaces.replacedProxy();
            if (!replacedTemplate.isAnnotationPresent(Replaceable.class)) {
                throw new IllegalArgumentException("Template " + replacedTemplate.getName() + " is not replaceable");
            }
            try {
                AbstractTemplateProxy.ReplacementConstructor previousReplacementConstructor = this.replacementConstructors.put(replacedTemplate, replaces.replacementConstructor().newInstance());
                if (previousReplacementConstructor == null) continue;
                throw new IllegalArgumentException("Template " + replacedTemplate.getName() + " is replaced by both " + previousReplacementConstructor.getClass().getEnclosingClass().getName() + " and " + replaces.replacementConstructor().getClass().getEnclosingClass().getName());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected AbstractTemplateProxy.ReplacementConstructor findReplacement(Class<? extends AbstractTemplateProxy> proxyClass, Object jamonContext) {
        return this.replacementConstructors.get(proxyClass);
    }
}

