/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.monitor;

import org.json.simple.JSONAware;

public class KafkaOffsetLagResult
implements JSONAware {
    private String topic;
    private int partition;
    private long consumerCommittedOffset;
    private long logHeadOffset;
    private long lag;

    public KafkaOffsetLagResult(String topic, int parition, long consumerCommittedOffset, long logHeadOffset) {
        this.topic = topic;
        this.partition = parition;
        this.consumerCommittedOffset = consumerCommittedOffset;
        this.logHeadOffset = logHeadOffset;
        this.lag = this.logHeadOffset - this.consumerCommittedOffset;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getConsumerCommittedOffset() {
        return this.consumerCommittedOffset;
    }

    public long getLogHeadOffset() {
        return this.logHeadOffset;
    }

    public long getLag() {
        return this.lag;
    }

    public String toString() {
        return "KafkaOffsetLagResult{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", consumerCommittedOffset=" + this.consumerCommittedOffset + ", logHeadOffset=" + this.logHeadOffset + ", lag=" + this.lag + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaOffsetLagResult that = (KafkaOffsetLagResult)o;
        if (this.partition != that.partition) {
            return false;
        }
        if (this.consumerCommittedOffset != that.consumerCommittedOffset) {
            return false;
        }
        if (this.logHeadOffset != that.logHeadOffset) {
            return false;
        }
        if (this.lag != that.lag) {
            return false;
        }
        return !(this.topic == null ? that.topic != null : !this.topic.equals(that.topic));
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + this.partition;
        result = 31 * result + (int)(this.consumerCommittedOffset ^ this.consumerCommittedOffset >>> 32);
        result = 31 * result + (int)(this.logHeadOffset ^ this.logHeadOffset >>> 32);
        result = 31 * result + (int)(this.lag ^ this.lag >>> 32);
        return result;
    }

    public String toJSONString() {
        return "{\"topic\":\"" + this.topic + "\",\"partition\":" + this.partition + ",\"consumerCommittedOffset\":" + this.consumerCommittedOffset + ",\"logHeadOffset\":" + this.logHeadOffset + ",\"lag\":" + this.lag + "}";
    }
}

