/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.utils;

import com.codahale.metrics.Meter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.daemon.utils.PathUtil;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerLogs {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerLogs.class);
    public static final String WORKER_YAML = "worker.yaml";
    private final Meter numSetPermissionsExceptions;
    private final Map<String, Object> stormConf;
    private final Path logRootDir;
    private final DirectoryCleaner directoryCleaner;

    public WorkerLogs(Map<String, Object> stormConf, Path logRootDir, StormMetricsRegistry metricsRegistry) {
        this.stormConf = stormConf;
        this.logRootDir = logRootDir.toAbsolutePath().normalize();
        this.numSetPermissionsExceptions = metricsRegistry.registerMeter("logviewer:num-set-permission-exceptions");
        this.directoryCleaner = new DirectoryCleaner(metricsRegistry);
    }

    public void setLogFilePermission(String fileName) throws IOException {
        Optional topoOwner;
        Path absFile = this.logRootDir.resolve(fileName).toAbsolutePath().normalize();
        if (!absFile.startsWith(this.logRootDir)) {
            return;
        }
        boolean runAsUser = ObjectReader.getBoolean((Object)this.stormConf.get("supervisor.run.worker.as.user"), (boolean)false);
        Path parent = this.logRootDir.resolve(fileName).getParent();
        Optional mdFile = parent == null ? Optional.empty() : this.getMetadataFileForWorkerLogDir(parent);
        Optional<Object> optional = topoOwner = mdFile.isPresent() ? Optional.of(this.getTopologyOwnerFromMetadataFile(((Path)mdFile.get()).toAbsolutePath().normalize())) : Optional.empty();
        if (runAsUser && topoOwner.isPresent() && absFile.toFile().exists() && !Files.isReadable(absFile)) {
            LOG.debug("Setting permissions on file {} with topo-owner {}", (Object)fileName, topoOwner);
            try {
                ClientSupervisorUtils.processLauncherAndWait(this.stormConf, (String)((String)topoOwner.get()), (List)Lists.newArrayList((Object[])new String[]{"blob", absFile.toAbsolutePath().normalize().toString()}), null, (String)("setup group read permissions for file: " + fileName));
            }
            catch (IOException e) {
                this.numSetPermissionsExceptions.mark();
                throw e;
            }
        }
    }

    public List<Path> getAllLogsForRootDir() throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        Set<Path> topoDirFiles = this.getAllWorkerDirs();
        if (topoDirFiles != null) {
            for (Path portDir : topoDirFiles) {
                files.addAll(this.directoryCleaner.getFilesForDir(portDir));
            }
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Path> getAllWorkerDirs() {
        try (Stream<Path> topoDirs = Files.list(this.logRootDir);){
            Set set = topoDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(Unchecked.function(Files::list)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toCollection(TreeSet::new));
            return set;
        }
        catch (IOException e) {
            throw Utils.wrapInRuntime((Exception)e);
        }
    }

    public SortedSet<Path> getAliveWorkerDirs() throws IOException {
        Set<String> aliveIds = this.getAliveIds(Time.currentTimeSecs());
        Set<Path> logDirs = this.getAllWorkerDirs();
        return this.getLogDirs(logDirs, wid -> aliveIds.contains(wid));
    }

    public Optional<Path> getMetadataFileForWorkerLogDir(Path logDir) throws IOException {
        Path metaFile = logDir.resolve(WORKER_YAML);
        if (metaFile.toFile().exists()) {
            return Optional.of(metaFile);
        }
        LOG.warn("Could not find {} to clean up for {}", (Object)metaFile.toAbsolutePath().normalize(), (Object)logDir);
        return Optional.empty();
    }

    public String getWorkerIdFromMetadataFile(Path metaFile) {
        Map map = (Map)Utils.readYamlFile((String)metaFile.toString());
        return ObjectReader.getString(map == null ? null : map.get("worker-id"), null);
    }

    public String getTopologyOwnerFromMetadataFile(Path metaFile) {
        Map map = (Map)Utils.readYamlFile((String)metaFile.toString());
        return ObjectReader.getString(map.get("topology.submitter.user"), null);
    }

    public Set<String> getAliveIds(int nowSecs) throws IOException {
        return SupervisorUtils.readWorkerHeartbeats(this.stormConf).entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue()) && !SupervisorUtils.isWorkerHbTimedOut((int)nowSecs, (LSWorkerHeartbeat)((LSWorkerHeartbeat)entry.getValue()), this.stormConf)).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
    }

    public SortedSet<Path> getLogDirs(Set<Path> logDirs, Predicate<String> predicate) {
        TreeSet<Path> ret = new TreeSet<Path>();
        for (Path logDir : logDirs) {
            String workerId = "";
            try {
                Optional<Path> metaFile = this.getMetadataFileForWorkerLogDir(logDir);
                if (metaFile.isPresent() && (workerId = this.getWorkerIdFromMetadataFile(metaFile.get().toAbsolutePath().normalize())) == null) {
                    workerId = "";
                }
            }
            catch (IOException e) {
                LOG.warn("Error trying to find worker.yaml in {}", (Object)logDir, (Object)e);
            }
            if (!predicate.test(workerId)) continue;
            ret.add(logDir);
        }
        return ret;
    }

    public static String getTopologyPortWorkerLog(Path file) {
        return PathUtil.truncatePathToLastElements(file.toAbsolutePath().normalize(), 3).toString();
    }
}

