/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc;

import com.codahale.metrics.Meter;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.storm.daemon.drpc.DRPC;
import org.apache.storm.daemon.drpc.DRPCThrift;
import org.apache.storm.daemon.drpc.webapp.DRPCApplication;
import org.apache.storm.daemon.drpc.webapp.ReqContextFilter;
import org.apache.storm.daemon.ui.FilterConfiguration;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.generated.DistributedRPC;
import org.apache.storm.generated.DistributedRPCInvocations;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ServerAuthUtils;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.ThriftServer;
import org.apache.storm.thrift.TProcessor;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCServer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DRPCServer.class);
    private final Meter meterShutdownCalls;
    private final DRPC drpc;
    private final ThriftServer handlerServer;
    private final ThriftServer invokeServer;
    private final Server httpServer;
    private Thread handlerServerThread;
    private boolean closed = false;

    public static void addRequestContextFilter(ServletContextHandler context, String configName, Map<String, Object> conf) {
        IHttpCredentialsPlugin auth = ServerAuthUtils.getHttpCredentialsPlugin(conf, (String)((String)conf.get(configName)));
        ReqContextFilter filter = new ReqContextFilter(auth);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
    }

    private static ThriftServer mkHandlerServer(DistributedRPC.Iface service, Integer port, Map<String, Object> conf) {
        ThriftServer ret = null;
        if (port != null && port >= 0) {
            ret = new ThriftServer(conf, (TProcessor)new DistributedRPC.Processor(service), ThriftConnectionType.DRPC);
        }
        return ret;
    }

    private static ThriftServer mkInvokeServer(DistributedRPCInvocations.Iface service, int port, Map<String, Object> conf) {
        return new ThriftServer(conf, (TProcessor)new DistributedRPCInvocations.Processor(service), ThriftConnectionType.DRPC_INVOCATIONS);
    }

    private static Server mkHttpServer(StormMetricsRegistry metricsRegistry, Map<String, Object> conf, DRPC drpc) {
        Integer drpcHttpPort = (Integer)conf.get("drpc.http.port");
        Server ret = null;
        if (drpcHttpPort != null && drpcHttpPort >= 0) {
            LOG.info("Starting RPC HTTP servers...");
            String filterClass = (String)conf.get("drpc.http.filter");
            Map filterParams = (Map)conf.get("drpc.http.filter.params");
            FilterConfiguration filterConfiguration = new FilterConfiguration(filterClass, filterParams);
            List<FilterConfiguration> filterConfigurations = Arrays.asList(filterConfiguration);
            Integer httpsPort = ObjectReader.getInt((Object)conf.get("drpc.https.port"), (Integer)0);
            String httpsKsPath = (String)conf.get("drpc.https.keystore.path");
            String httpsKsPassword = (String)conf.get("drpc.https.keystore.password");
            String httpsKsType = (String)conf.get("drpc.https.keystore.type");
            String httpsKeyPassword = (String)conf.get("drpc.https.key.password");
            String httpsTsPath = (String)conf.get("drpc.https.truststore.path");
            String httpsTsPassword = (String)conf.get("drpc.https.truststore.password");
            String httpsTsType = (String)conf.get("drpc.https.truststore.type");
            Boolean httpsWantClientAuth = (Boolean)conf.get("drpc.https.want.client.auth");
            Boolean httpsNeedClientAuth = (Boolean)conf.get("drpc.https.need.client.auth");
            Boolean disableHttpBinding = (Boolean)conf.get("drpc.disable.http.binding");
            DRPCApplication.setup(drpc, metricsRegistry);
            ret = UIHelpers.jettyCreateServer(drpcHttpPort, null, httpsPort, disableHttpBinding);
            UIHelpers.configSsl(ret, httpsPort, httpsKsPath, httpsKsPassword, httpsKsType, httpsKeyPassword, httpsTsPath, httpsTsPassword, httpsTsType, httpsNeedClientAuth, httpsWantClientAuth);
            ServletContextHandler context = new ServletContextHandler(0);
            context.setContextPath("/");
            ret.setHandler((Handler)context);
            ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/*");
            jerseyServlet.setInitOrder(1);
            jerseyServlet.setInitParameter("javax.ws.rs.Application", DRPCApplication.class.getName());
            UIHelpers.configFilters(context, filterConfigurations);
            DRPCServer.addRequestContextFilter(context, "drpc.http.creds.plugin", conf);
        }
        return ret;
    }

    public DRPCServer(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) {
        this.meterShutdownCalls = metricsRegistry.registerMeter("drpc:num-shutdown-calls");
        this.drpc = new DRPC(metricsRegistry, conf);
        DRPCThrift thrift = new DRPCThrift(this.drpc);
        this.handlerServer = DRPCServer.mkHandlerServer((DistributedRPC.Iface)thrift, ObjectReader.getInt((Object)conf.get("drpc.port"), null), conf);
        this.invokeServer = DRPCServer.mkInvokeServer((DistributedRPCInvocations.Iface)thrift, ObjectReader.getInt((Object)conf.get("drpc.invocations.port"), (Integer)3773), conf);
        this.httpServer = DRPCServer.mkHttpServer(metricsRegistry, conf, this.drpc);
    }

    @VisibleForTesting
    void start() throws Exception {
        LOG.info("Starting Distributed RPC servers...");
        new Thread(() -> ((ThriftServer)this.invokeServer).serve()).start();
        if (this.httpServer != null) {
            this.httpServer.start();
        }
        if (this.handlerServer != null) {
            this.handlerServerThread = new Thread(() -> ((ThriftServer)this.handlerServer).serve());
            this.handlerServerThread.start();
        }
    }

    @VisibleForTesting
    void awaitTermination() throws InterruptedException {
        if (this.handlerServerThread != null) {
            this.handlerServerThread.join();
        } else {
            this.httpServer.join();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            if (this.handlerServer != null) {
                this.handlerServer.stop();
            }
            if (this.invokeServer != null) {
                this.invokeServer.stop();
            }
            this.drpc.close();
            this.closed = true;
        }
    }

    public int getDrpcPort() {
        return this.handlerServer.getPort();
    }

    public int getDrpcInvokePort() {
        return this.invokeServer.getPort();
    }

    public int getHttpServerPort() {
        assert (this.httpServer.getConnectors().length == 1);
        return ((ServerConnector)this.httpServer.getConnectors()[0]).getLocalPort();
    }

    public static void main(String[] args) throws Exception {
        Utils.setupDefaultUncaughtExceptionHandler();
        Map conf = ConfigUtils.readStormConfig();
        StormMetricsRegistry metricsRegistry = new StormMetricsRegistry();
        try (DRPCServer server = new DRPCServer(conf, metricsRegistry);){
            metricsRegistry.startMetricsReporters(conf);
            Utils.addShutdownHookWithForceKillIn1Sec(() -> {
                server.meterShutdownCalls.mark();
                metricsRegistry.stopMetricsReporters();
                server.close();
            });
            server.start();
            server.awaitTermination();
        }
    }
}

